/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.Maske;
import de.superx.common.NotYetImplementedException;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.NumberListFormatTool;
import de.superx.rest.config.ValueFormatTool;
import de.superx.rest.config.WordListFormatTool;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeModel;

public abstract class HisDynamicFieldConfigurator {
    private static String LABEL_TEXT_ALLE = "Alle";
    protected HisDynamicFieldConfig config = null;
    protected Field field;
    protected Maske maske;
    protected SxUser user;

    public abstract HisDynamicFieldConfig createConfig(String var1) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, TemplateException, IOException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException;

    public abstract String escapeForFormular(String var1) throws UngueltigeEingabeException;

    public abstract String getUpdatedFormularValue();

    protected static String addQuotes(String listString) {
        return ValueFormatTool.addQuotes(listString);
    }

    protected static List<Item> createSelectableItems(Field field) {
        ArrayList<Item> items = new ArrayList<Item>();
        TreeModel model = field.getSelectableItemsTree().getModel();
        SelectableItemNode root = (SelectableItemNode)model.getRoot();
        int childCount = model.getChildCount(root);
        for (int i = 0; i < childCount; ++i) {
            SelectableItemNode node = (SelectableItemNode)model.getChild(root, i);
            SelectableItem item = (SelectableItem)node.getUserObject();
            String value = (String)item.getId();
            String label = item.getName();
            if (label.toLowerCase().contentEquals("alle")) {
                label = LABEL_TEXT_ALLE;
            }
            if (!label.isEmpty()) {
                items.add(new Item(label, value));
                continue;
            }
            if (FieldType.getCorrectedFieldType(field) == FieldType.MultiSelect || field.isObligatorisch()) continue;
            items.add(new Item(label, value));
        }
        return items;
    }

    protected static List<String> extractValues(List<Item> items) {
        ArrayList<String> extractedValues = new ArrayList<String>();
        for (Item item : items) {
            if (item == null) continue;
            extractedValues.add(item.value);
        }
        return extractedValues;
    }

    protected static ValueFormatTool createValueFormatTool(Field field) throws NotYetImplementedException {
        Field.Typ feldTyp = field.getTyp();
        switch (feldTyp) {
            case typ_char: {
                return new WordListFormatTool();
            }
            case typ_integer: 
            case typ_decimal: {
                return new NumberListFormatTool();
            }
        }
        throw new NotYetImplementedException("not yet implemented");
    }

    protected static String[] filterValidValues(List<Item> validItems, String[] inputValues) {
        List<String> validValues = HisDynamicFieldConfigurator.extractValues(validItems);
        ArrayList<String> filteredValues = new ArrayList<String>();
        for (String value : inputValues) {
            if (!validValues.contains(value)) continue;
            filteredValues.add(value);
        }
        return filteredValues.toArray(new String[0]);
    }

    protected static String[] toStringArray(String commaSeparatedList) {
        if (commaSeparatedList == null || commaSeparatedList.equals("")) {
            return new String[0];
        }
        return commaSeparatedList.split(",");
    }
}

