/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.common.TransletCache;
import de.superx.rest.CacheInfo;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxSQL_Server;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import javax.ws.rs.core.Context;
import javax.xml.transform.TransformerConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cache"})
public class Cache {
    private static Logger logger = LoggerFactory.getLogger(Cache.class);

    @RequestMapping(path={"/clear"}, method={RequestMethod.POST})
    public static CacheInfo clear(@Context HttpServletRequest httpRequest) {
        try {
            SuperXManager.initPool(httpRequest, SxSQL_Server.DEFAULT_MANDANTEN_ID);
            SuperXManager.initMondrianSchema(null, null);
        }
        catch (Exception e) {
            logger.error("Error. Cannot clear server cache.", (Throwable)e);
        }
        return Cache.status();
    }

    @RequestMapping(method={RequestMethod.GET})
    public static CacheInfo status() {
        return new CacheInfo(TransletCache.getLastClear(), TransletCache.getTransletPoolSize(), TransletCache.getMerkmaleSize());
    }

    @RequestMapping(path={"/clearpool"}, method={RequestMethod.GET})
    public static String clearpool(@Context HttpServletRequest httpRequest) {
        Object returntext = "Problem: Cannot clear server cache.";
        try {
            Object mandantobject = httpRequest.getSession().getAttribute("MandantenID");
            String mandantenid = mandantobject != null ? mandantobject.toString() : SxSQL_Server.DEFAULT_MANDANTEN_ID;
            SuperXManager.initPool(httpRequest, mandantenid);
            SuperXManager.initStandardXsl();
            returntext = "Resources neu geladen: <br />" + DateUtils.getTodayString() + " " + DateUtils.getNowString();
        }
        catch (DBServletException | IOException | SQLException | TransformerConfigurationException e) {
            logger.error("Error. Cannot clear server cache.", (Throwable)e);
        }
        return returntext;
    }

    @RequestMapping(path={"/cleartranslet"}, method={RequestMethod.GET})
    public static String cleartranslet(@Context HttpServletRequest httpRequest) {
        Object returntext = "Problem: Cannot clear translet cache.";
        try {
            Object mandantobject = httpRequest.getSession().getAttribute("MandantenID");
            String mandantenid = mandantobject != null ? mandantobject.toString() : SxSQL_Server.DEFAULT_MANDANTEN_ID;
            SuperXManager.clearTransletStylesheets();
            returntext = "TransletCache neu geladen: <br />" + DateUtils.getTodayString() + " " + DateUtils.getNowString();
        }
        catch (Exception e) {
            logger.error("Error. Cannot clear server cache.", (Throwable)e);
        }
        return returntext;
    }
}

