/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl;

import de.memtext.util.StringUtils;
import de.superx.bin.SxConnection;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxSqlHelper;
import de.superx.etl.ActionHandler.EtlActionHandlerI;
import de.superx.etl.EtlAction;
import de.superx.util.SqlStringUtils;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class EtlStep
extends EtlAction {
    private String mandantenID;
    private Integer stepTid;
    private String stepUniquename;
    private String stepLogfile;
    private String stepCaption;
    private Integer stepSortnr;
    private Integer stepParentStepId;
    private String stepTypeUniquename;
    private String stepTypeCaption;
    public String stepTypeHandler;
    public Properties jobRunTimeParams;
    public Properties stepProperties;
    private SxConnection stepSxConnection;
    private Connection stepConnection;
    private StringWriter sw;

    public EtlStep(String uniquename, String logfile, String propfile) {
        super(uniquename, logfile, propfile);
        super.addActionLog("Step " + uniquename + " loaded");
    }

    public StringWriter getOutputStringWriter() {
        return this.sw;
    }

    public void setOutputStringWriter(StringWriter sw) {
        this.sw = sw;
    }

    public void initStep(String job, Properties runTimeParams, Integer tid, String uniquename, String logfile, String caption, Integer sortnr, Integer forceContinue, Integer parentStepId, String typeUniquename, String typeCaption, String typeHandler) throws Exception {
        this.jobRunTimeParams = runTimeParams;
        this.stepTypeHandler = typeHandler;
        this.stepTid = tid;
        this.stepUniquename = uniquename;
        this.stepLogfile = logfile;
        this.stepCaption = caption;
        this.stepSortnr = sortnr;
        this.stepForceContinue = forceContinue;
        this.stepParentStepId = parentStepId;
        this.stepTypeUniquename = typeUniquename;
        this.stepTypeCaption = typeCaption;
        this.setLogfile(logfile);
        super.addActionLog("Initializing Step: " + caption);
        super.addActionLog("Handler: " + typeHandler);
        this.initConnectionIfNecessary();
        if (!SqlStringUtils.checkValidKeyEntry(job)) {
            throw new SQLException("Invalid job");
        }
        String sql = "select tid,prop_name,prop_value from etl_step_property where etl_step_id=" + tid.toString() + ";";
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        sh.execute(sql, this.getDbconnection(), el);
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei Step DETAILS:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        SxResultSet result = el.getResultSet();
        this.stepProperties = null;
        this.stepProperties = new Properties();
        int rownr = 0;
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ++rownr;
            SxResultRow row = (SxResultRow)it.next();
            String paramName = row.get(1).toString().trim();
            String paramValue = row.get(2).toString().trim();
            String paramValueParsed = this.parseParams(paramValue);
            this.stepProperties.setProperty(paramName, paramValueParsed);
            super.addActionLog("Parameter " + paramName + ":" + paramValueParsed);
        }
    }

    private String parseParams(String paramValue) {
        String parsedParam = paramValue;
        Enumeration<?> runTimeParamNames = this.jobRunTimeParams.propertyNames();
        while (runTimeParamNames.hasMoreElements()) {
            String runTimeParamName = (String)runTimeParamNames.nextElement();
            String runTimeParamValue = this.jobRunTimeParams.getProperty(runTimeParamName);
            parsedParam = StringUtils.replace(parsedParam, "$" + runTimeParamName, runTimeParamValue);
        }
        return parsedParam;
    }

    @Override
    public int execute() throws Exception {
        int returnCode = 0;
        super.addActionLog("Executing Step " + this.stepUniquename);
        Class<?> handlerClass = Class.forName(this.stepTypeHandler);
        EtlActionHandlerI handler = (EtlActionHandlerI)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        handler.setHandlerSpecificProperties(this.stepProperties);
        handler.setRunTimeParams(this.jobRunTimeParams);
        handler.setOutputStringWriter(this.getOutputStringWriter());
        handler.setPropFile(this.getPropfile());
        try {
            returnCode = handler.execute(this.getOutputStringWriter(), "default", this.stepUniquename, "xml");
        }
        catch (Exception e) {
            returnCode = 1;
            super.addActionLog("Fehler beim Step " + this.stepUniquename + ": " + e.toString());
        }
        this.setOutputStringWriter(handler.getOutputStringWriter());
        super.addActionLog(handler.getLogOutput());
        return returnCode;
    }
}

