/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbtMetrics {
    private static final String METRICS_LINE = "Found (\\d+) models, (\\d+) snapshots, (\\d+) data tests, (\\d+) seeds, (\\d+) sources, (\\d+) macros";
    private static final Pattern METRICS_PATTERN = Pattern.compile("Found (\\d+) models, (\\d+) snapshots, (\\d+) data tests, (\\d+) seeds, (\\d+) sources, (\\d+) macros");
    private int models;
    private int snapshots;
    private int tests;
    private int seeds;
    private int sources;
    private int macros;

    public DbtMetrics(String metricLine) {
        Matcher metricsMatcher = METRICS_PATTERN.matcher(metricLine);
        if (metricsMatcher.find()) {
            this.models = Integer.parseInt(metricsMatcher.group(1));
            this.snapshots = Integer.parseInt(metricsMatcher.group(2));
            this.tests = Integer.parseInt(metricsMatcher.group(3));
            this.seeds = Integer.parseInt(metricsMatcher.group(4));
            this.sources = Integer.parseInt(metricsMatcher.group(5));
            this.macros = Integer.parseInt(metricsMatcher.group(6));
        }
    }

    public int getExecCount(boolean isTests) {
        return isTests ? this.tests : this.models + this.snapshots + this.seeds;
    }

    public int getModels() {
        return this.models;
    }

    public int getSnapshots() {
        return this.snapshots;
    }

    public int getTests() {
        return this.tests;
    }

    public int getSeeds() {
        return this.seeds;
    }

    public int getSources() {
        return this.sources;
    }

    public int getMacros() {
        return this.macros;
    }
}

