/*
 * Decompiled with CFR 0.152.
 */
package de.superx.conf;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class InitStatus {
    private static Map<SubSystem, Optional<Throwable>> initErrors = new LinkedHashMap<SubSystem, Optional<Throwable>>();

    private InitStatus() {
    }

    public static synchronized void setStatus(SubSystem subSystem, Optional<Throwable> status) {
        initErrors.put(subSystem, status);
    }

    public static Optional<Throwable> getStatus(SubSystem subSystem) {
        return initErrors.get((Object)subSystem);
    }

    public static boolean getStatusOk(SubSystem subSystem) {
        return !initErrors.get((Object)subSystem).isPresent();
    }

    public static Map<SubSystem, Boolean> getSubSystemStatus() {
        LinkedHashMap<SubSystem, Boolean> result = new LinkedHashMap<SubSystem, Boolean>();
        for (Map.Entry<SubSystem, Optional<Throwable>> entry : initErrors.entrySet()) {
            result.put(entry.getKey(), !entry.getValue().isPresent());
        }
        return result;
    }

    public static enum SubSystem {
        OrgunitMapping,
        SichtartRechteDefinition,
        FinRights,
        FMTemplates,
        Repository,
        Translations,
        HeaderFooterDB,
        MacroFieldSelections,
        GraphicsFormats,
        FieldElementCache,
        ExcelTemplate,
        ExternalPools,
        HasKontierungsRechte,
        HasImplicitOrgunitsRightTable,
        JasperReports,
        SaikuJCR,
        SaikuSchema;

    }
}

