/*
 * Decompiled with CFR 0.152.
 */
package de.superx.conf;

import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.log4j.Logger;

public class ApplicationConfig {
    private static Logger logger = Logger.getLogger(ApplicationConfig.class);
    private static Properties applicationProperties;

    public static synchronized void readApplicationProperties() {
        String webinf = PathAndFileUtils.getWebinfPath();
        File applicationPropertiesFile = new File(webinf + File.separator + "conf" + File.separator + "application.properties");
        File customApplicationPropertiesFile = new File(webinf + File.separator + "conf" + File.separator + "application_custom.properties");
        ApplicationConfig.readApplicationProperties(applicationPropertiesFile, customApplicationPropertiesFile);
    }

    static synchronized void readApplicationProperties(File propertiesFile, File customPropertiesFile) {
        logger.info((Object)("Reading " + propertiesFile.getName()));
        Properties properties = ApplicationConfig.readPropertiesFile(propertiesFile);
        if (customPropertiesFile.exists()) {
            logger.info((Object)("Merging " + customPropertiesFile.getName()));
            Properties customProperties = ApplicationConfig.readPropertiesFile(customPropertiesFile);
            properties.putAll((Map<?, ?>)customProperties);
        }
        applicationProperties = properties;
    }

    public static int getKeyCount() {
        return applicationProperties.size();
    }

    public static String get(Key key) {
        return applicationProperties.getProperty(key.getKey());
    }

    public static Object getWithType(Key key) {
        return key.parseValue(applicationProperties.getProperty(key.getKey()));
    }

    private static Properties readPropertiesFile(File file) {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(file));
            ApplicationConfig.checkKeys(properties);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("File " + file.getName() + " not found!"));
        }
        catch (IOException e) {
            logger.error((Object)("Could not read " + file.getName()));
        }
        return properties;
    }

    private static void checkKeys(Properties properties) {
        for (Object k : properties.keySet()) {
            Key key = Key.fromKey((String)k);
            logger.debug((Object)("Check key " + String.valueOf((Object)key)));
            if (key == null) {
                properties.remove(k);
                logger.warn((Object)("Invalid key \"" + String.valueOf(k) + "\" removed from config"));
                continue;
            }
            String val = properties.getProperty(key.key);
            logger.debug((Object)("Value " + val));
            if (key.parseValue(val) != null) continue;
            properties.remove(k);
            logger.warn((Object)("Invalid value \"" + val + "\" for \"" + String.valueOf((Object)key) + "\" removed from config"));
        }
    }

    public static enum Key {
        init_health_check("init.health_check", ValType.bool),
        dbt_job_execution_timeout_seconds("dbt.job_execution_timeout_seconds", ValType.integer);

        private String key;
        private ValType valType;

        private Key(String key, ValType valType) {
            this.key = key;
            this.valType = valType;
        }

        public String getKey() {
            return this.key;
        }

        public ValType getValType() {
            return this.valType;
        }

        public Object parseValue(String val) {
            try {
                switch (this.valType) {
                    case bool: {
                        return BooleanUtils.toBooleanObject((String)val);
                    }
                    case string: {
                        return val;
                    }
                    case integer: {
                        return Integer.valueOf(val);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Couldn't parse value " + val), (Throwable)ex);
            }
            return null;
        }

        public static boolean exists(String k) {
            for (Key key : Key.values()) {
                if (!k.equals(key.key)) continue;
                return true;
            }
            return false;
        }

        public static Key fromKey(String k) {
            for (Key key : Key.values()) {
                if (!k.equals(key.key)) continue;
                return key;
            }
            return null;
        }
    }

    static enum ValType {
        bool,
        string,
        integer;

    }
}

