/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.NamedIdObjectI;
import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.baseobjects.coll.NamedObjectList;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.StringUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.SichtException;
import de.superx.common.SichtartRechte;
import de.superx.common.Sichtgruppe;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.servlet.ServletUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class Sichten
extends NamedIdObjectSet {
    private static Integer ID_VALUE_0 = 0;
    private static Integer ID_VALUE_1 = 1;
    private static Integer ID_VALUE_2 = 2;
    private static Integer OBJECT_0 = 0;
    private static Integer OBJECT_1 = 1;
    private static Integer OBJECT_2 = 2;
    private static final long serialVersionUID = 1L;
    private static final Class[] CONSTRPARAMS = new Class[]{Sichten.class, Object.class, String.class};
    private NamedIdObjectSet hauptsichten = new NamedIdObjectSet();
    public Sichtgruppe standardOrganigrammGruppe = new Sichtgruppe("standardOrganigrammGruppe");
    public Sichtgruppe oldLehreMitUserrechtenGruppe = new Sichtgruppe("oldLehreMitUserrechtenGruppe");
    public Sichtgruppe oldLehreOhneUserrechteGruppe = new Sichtgruppe("oldLehreOhneUserrechteGruppe");
    private SxUser user;
    private NamedObjectList sichtartRechteList = new NamedObjectList();

    public Sichten() {
        super(Collections.synchronizedSet(new LinkedHashSet()));
    }

    @Override
    public synchronized NamedIdObjectI getById(Object id) {
        AbstractSicht sicht = null;
        try {
            sicht = (AbstractSicht)super.getById(id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Es ist keine Sicht mit der Nummer " + String.valueOf(id) + " bekannt.");
        }
        return sicht;
    }

    public void addSichtartRechte(String sichtartname, boolean fallback_user_inst, SxResultSet rs) {
        SichtartRechte sr = null;
        if (!this.sichtartRechteList.containsItemWithName(sichtartname)) {
            sr = new SichtartRechte();
            sr.setName(sichtartname);
            sr.setActive(true);
            this.sichtartRechteList.add(sr);
        } else {
            sr = (SichtartRechte)this.sichtartRechteList.getByName(sichtartname);
        }
        sr.setFallback_user_inst(fallback_user_inst);
        for (SxResultRow row : rs) {
            String key = (String)row.get(0);
            key = StringUtils.replace(key, " ", "");
            sr.addKey(key);
        }
    }

    public String getSichtartKeys(String sichtart) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        TreeSet<String> keys = new TreeSet<String>();
        LinkedList<AbstractSicht> initSichten = new LinkedList<AbstractSicht>();
        for (AbstractSicht sicht : this) {
            if (!sicht.getArt().equals(sichtart)) continue;
            initSichten.add(sicht);
        }
        Hashtable formular = new Hashtable();
        HashMap map = new HashMap();
        FieldContainer individualFields = new FieldContainer();
        for (AbstractSicht sicht : initSichten) {
            sicht.setStand(formular, map, individualFields, "1.1.1970");
        }
        for (AbstractSicht sicht : this) {
            if (!sicht.getArt().equals(sichtart)) continue;
            keys.addAll(sicht.getAllKeysSet());
        }
        StringBuffer result = new StringBuffer("");
        if (keys.size() > 0) {
            result.append(" (");
            Iterator it2 = keys.iterator();
            while (it2.hasNext()) {
                result.append("'" + (String)it2.next() + "',");
            }
            StringUtils.removeFromEnd(result, ",", false);
            result.append(") ");
        }
        return result.toString();
    }

    public static String getReadingSql(SxUser user) {
        Object sql = "";
        sql = user.isAdmin() ? "select tid,name,label,'',beschreibung,quelle,standbutton,art  \n\t,type,alt_hier_id,treecfgtable,treecfgid,gueltig_seit,gueltig_bis,xmlmaxentries,name_intern,attribut1,attribut2,attribut3,cacheapplet,cachexml \nfrom sichten where aktiv=1 order by type" : "select tid,name,label,'',beschreibung,quelle,standbutton,art  \n\t,type,alt_hier_id,treecfgtable,treecfgid,gueltig_seit,gueltig_bis,xmlmaxentries,name_intern,attribut1,attribut2,attribut3,cacheapplet,cachexml \nfrom sichten where aktiv=1 and type=10 union select tid,name,label,'',beschreibung,quelle,standbutton,art  \n\t,type,alt_hier_id,treecfgtable,treecfgid,gueltig_seit,gueltig_bis,xmlmaxentries,name_intern,attribut1,attribut2,attribut3,cacheapplet,cachexml \nfrom sichten S \nwhere type!=10 and \n" + Sichten.getErlaubteSichtenSql(user);
        return sql;
    }

    public static String getErlaubteSichtenSql(SxUser user) {
        return " aktiv=1 and (\nS.name_intern in (select sicht_name_intern from user_sichten where userinfo_id=" + String.valueOf(user.getId()) + ") or \nS.art in (select sichtart from user_sichtarten where userinfo_id=" + String.valueOf(user.getId()) + ") or \nS.name_intern in (select sicht_name_intern from group_sichten where groupinfo_id in  \n (select groupinfo_id from user_group_bez where userinfo_id=" + String.valueOf(user.getId()) + ")) or  \n S.art in (select sichtart from group_sichtarten where groupinfo_id in  \n (select groupinfo_id from user_group_bez where userinfo_id=" + String.valueOf(user.getId()) + ")) \nor  S.name_intern in  \n              (select sicht_name_intern from sachgeb_sichten SG, user_sachgeb_bez U \n               where SG.sachgebiete_id=U.sachgebiete_id  and U.userinfo_id=" + String.valueOf(user.getId()) + ") \n              or \n              S.art in \n              (select sichtart from sachgeb_sichtarten SG, user_sachgeb_bez U \n               where SG.sachgebiete_id=U.sachgebiete_id  and U.userinfo_id=" + String.valueOf(user.getId()) + ") \n               or \n               S.name_intern in (select sicht_name_intern from sachgeb_sichten SG, group_sachgeb_bez G, user_group_bez UG \n               where SG.sachgebiete_id=G.sachgebiete_id  and G.groupinfo_id=UG.groupinfo_id and UG.userinfo_id=" + String.valueOf(user.getId()) + ") \n              or \n              S.art in \n              (select sichtart from sachgeb_sichtarten SG, group_sachgeb_bez G, user_group_bez UG \n               where SG.sachgebiete_id=G.sachgebiete_id  and G.groupinfo_id=UG.groupinfo_id and UG.userinfo_id=" + String.valueOf(user.getId()) + ")) order by type";
    }

    @Override
    public void clear() {
        this.reset();
        super.clear();
    }

    public synchronized void reset() {
        for (AbstractSicht sicht : this) {
            sicht.reset();
        }
    }

    public void init(String mandantenID, SxResultSet dbresult, Class sichtImpl) throws SQLException, DBServletException, KeyParentEqualException {
        this.clear();
        this.initSichtenF\u00fcrAlteDlgarten(mandantenID, sichtImpl);
        for (SxResultRow row : dbresult) {
            Integer id = (Integer)row.get(0);
            if (id < 10) {
                this.setAlteDlgArtenParams(id, row);
                continue;
            }
            this.initNonInternalSicht(mandantenID, sichtImpl, row, id);
        }
        this.standardOrganigrammGruppe.clear();
        this.oldLehreMitUserrechtenGruppe.clear();
        this.oldLehreOhneUserrechteGruppe.clear();
        this.standardOrganigrammGruppe.add(this.getById(ID_VALUE_0));
        this.oldLehreMitUserrechtenGruppe.add(this.getById(ID_VALUE_1));
        this.oldLehreOhneUserrechteGruppe.add(this.getById(ID_VALUE_2));
    }

    public void initNonInternalSicht(String mandantenID, Class sichtImpl, SxResultRow row, Integer id) throws SQLException, DBServletException, KeyParentEqualException {
        AbstractSicht sicht = null;
        Object[] constr = new Object[]{this, id, row.get(1)};
        try {
            sicht = (AbstractSicht)sichtImpl.getConstructor(CONSTRPARAMS).newInstance(constr);
        }
        catch (InternalError e) {
            throw new RuntimeException("Konnte Sicht " + String.valueOf(row.get(3)) + " nicht aufbauen - wenn keine graphische Umgebung verfuegbar Tomcat mit -Djava.awt.headless=true starten \n(in SQL_ENV zu JAVA_OPTS hinzuf\u00fcgen)\n" + String.valueOf(e));
        }
        catch (Exception e) {
            throw new SQLException("Konnte Sicht " + String.valueOf(row.get(3)) + " nicht aufbauen. DETAILS:" + e.toString());
        }
        sicht.setMandantenID(mandantenID);
        Object o = row.get(2);
        if (o != null) {
            sicht.setLabel(Integer.parseInt(o.toString()));
        }
        sicht.setName_intern(row.get(3).toString());
        sicht.setBeschreibung(row.get(4).toString());
        sicht.setQuelle(row.get(5).toString());
        sicht.setStandbuttonWanted(row.get(6).toString().equals("1"));
        sicht.setArt(row.get(7).toString());
        sicht.setType((Integer)row.get(8));
        sicht.setAltHierId((String)row.get(9));
        if (sicht.getType() == 10) {
            this.hauptsichten.add(sicht);
        } else if (sicht.getType() == 20) {
            sicht.setHauptSicht(this.getHauptSicht(sicht));
        }
        String table = (String)row.get(10);
        if (table != null && table.trim().equals("")) {
            table = null;
        }
        sicht.setTreeCfgTable(table);
        sicht.setTreeCfgId((String)row.get(11));
        sicht.setValidSince((Date)row.get(12));
        sicht.setValidTill((Date)row.get(13));
        sicht.setXmlMaxEntries((Integer)row.get(14));
        sicht.setName_intern((String)row.get(15));
        sicht.setAttribut1((String)row.get(16));
        sicht.setAttribut2((String)row.get(17));
        sicht.setAttribut3((Integer)row.get(18));
        String quelle = String.valueOf(row.get(5)) + " ";
        if (row.get(19) != null) {
            quelle = quelle + String.valueOf(row.get(19));
        }
        if (row.get(20) != null) {
            quelle = quelle + " " + String.valueOf(row.get(20));
        }
        sicht.setQuelle(quelle);
        sicht.setUser(this.user);
        if (this.sichtartRechteList.containsItemWithName(sicht.getArt())) {
            sicht.setSichtartRechte((SichtartRechte)this.sichtartRechteList.getByName(sicht.getArt()));
        }
        this.add(sicht);
    }

    private void setAlteDlgArtenParams(Integer id, SxResultRow row) {
        if (id <= 2) {
            AbstractSicht sicht = (AbstractSicht)this.getById(id);
            sicht.setXmlMaxEntries((Integer)row.get(14));
        }
    }

    private synchronized AbstractSicht getHauptSicht(AbstractSicht s) {
        AbstractSicht result = null;
        int hauptsichtCountFuerArt = 0;
        StringBuffer hauptsichtenNamen = new StringBuffer();
        for (AbstractSicht eineSicht : this.hauptsichten) {
            if (!eineSicht.getArt().equals(s.getArt())) continue;
            result = eineSicht;
            ++hauptsichtCountFuerArt;
            hauptsichtenNamen.append(eineSicht.getName() + " (interner Name:" + eineSicht.getName_intern() + "),");
        }
        if (hauptsichtCountFuerArt > 1) {
            StringUtils.deleteLastChar(hauptsichtenNamen);
            StringBuffer msg = new StringBuffer("F\u00fcr Sichtart \"" + s.getArt() + "\" und alt.Hier:\"" + s.getName() + "\" ist mehr als eine Hauptsicht hinterlegt. (" + String.valueOf(hauptsichtenNamen) + ") Die Sicht, die die Grundlage f\u00fcr die alt.Hierarchie sein soll muss type=10 gesetzt haben, die anderen type=15");
            throw new IllegalStateException(msg.toString());
        }
        if (result == null) {
            throw new IllegalArgumentException("Keine Hauptsicht (mit type=10) f\u00fcr Sicht (alt.Hier) " + s.getName() + " (" + String.valueOf(s.getId()) + ") gefunden.");
        }
        return result;
    }

    private void initSichtenF\u00fcrAlteDlgarten(String mandantenID, Class sichtImpl) throws SQLException {
        Object[] constr = new Object[3];
        try {
            constr[0] = this;
            constr[1] = OBJECT_0;
            constr[2] = "Organisatorische Sicht";
            Constructor con = sichtImpl.getConstructor(CONSTRPARAMS);
            AbstractSicht standardSicht = null;
            try {
                standardSicht = (AbstractSicht)con.newInstance(constr);
            }
            catch (InternalError e) {
                throw new RuntimeException("Konnte Standardsicht 0 nicht aufbauen DETAILS: bei X11 Problemen Tomcat mit -Djava.awt.headless=true gestartet werden \n(in SQL_ENV zu JAVA_OPTS hinzuf\u00fcgen)\n" + String.valueOf(e));
            }
            standardSicht.setName_intern("alteFeldart4");
            standardSicht.setMandantenID(mandantenID);
            standardSicht.setPerfectlyRegular(true);
            standardSicht.setLabel(0);
            standardSicht.setQuelle("sp_user_orga(<<UserID>>,<<Stand>>,<<Sicht>>);select distinct name,key_apnr,parent,lehre,erlaubt,orgstruktur,lid,parent_lid from tmp_organigramm order by name;drop table tmp_organigramm;");
            standardSicht.setArt("Organigramm-Sicht");
            standardSicht.setStandbuttonWanted(true);
            standardSicht.setUser(this.user);
            standardSicht.setAllowed(true);
            constr[1] = OBJECT_1;
            constr[2] = "Organisatorische Sicht (Lehre)";
            AbstractSicht lehreSicht = (AbstractSicht)sichtImpl.getConstructor(CONSTRPARAMS).newInstance(constr);
            lehreSicht.setName_intern("alteFeldart6");
            lehreSicht.setMandantenID(mandantenID);
            lehreSicht.setLabel(1);
            lehreSicht.setQuelle("sp_user_orga(<<UserID>>,<<Stand>>,<<Sicht>>);select distinct name,key_apnr,parent,lehre,erlaubt,orgstruktur,lid,parent_lid from tmp_organigramm order by name;drop table tmp_organigramm;");
            lehreSicht.setArt("Organigramm-Sicht");
            lehreSicht.setStandbuttonWanted(true);
            lehreSicht.setPerfectlyRegular(true);
            lehreSicht.setUser(this.user);
            lehreSicht.setAllowed(true);
            constr[1] = OBJECT_2;
            constr[2] = "Organisatorische Sicht (Lehre)";
            AbstractSicht lehreSicht2 = (AbstractSicht)sichtImpl.getConstructor(CONSTRPARAMS).newInstance(constr);
            lehreSicht2.setName_intern("alteFeldart7");
            lehreSicht2.setMandantenID(mandantenID);
            lehreSicht2.setLabel(2);
            lehreSicht2.setQuelle("sp_user_orga(<<UserID>>,<<Stand>>,<<Sicht>>);select distinct name,key_apnr,parent,lehre,erlaubt,orgstruktur,lid,parent_lid from tmp_organigramm order by name;drop table tmp_organigramm;");
            lehreSicht2.setArt("Organigramm-Sicht");
            lehreSicht2.setStandbuttonWanted(true);
            lehreSicht2.setPerfectlyRegular(true);
            lehreSicht2.setUser(this.user);
            lehreSicht2.setAllowed(true);
            this.add(standardSicht);
            this.add(lehreSicht);
            this.add(lehreSicht2);
        }
        catch (InvocationTargetException e) {
            System.err.println("TargetException");
            e.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Konnte Sicht f\u00fcr alte Dialogarten nicht initialisieren.\n" + e.toString());
        }
    }

    public void setUser(SxUser user) {
        this.user = user;
        for (AbstractSicht sicht : this) {
            sicht.setUser(user);
        }
    }

    public synchronized void setAllowedSichten(SxResultSet result, boolean isAdmin) {
        for (AbstractSicht eineSicht : this) {
            if (!isAdmin && Integer.parseInt(eineSicht.getId().toString()) >= 10) continue;
            eineSicht.setAllowed(true);
        }
        for (SxResultRow row : result) {
            Integer eineErlaubteTid = (Integer)row.get(0);
            if (!this.containsItemWithId(eineErlaubteTid)) {
                throw new IllegalArgumentException("Der User " + String.valueOf(this.user) + " sollte Rechte f\u00fcr die Sicht " + eineErlaubteTid + " bekommen, diese wurde vorher aber nicht eingelesen");
            }
            ((AbstractSicht)this.getById(eineErlaubteTid)).setAllowed(true);
        }
    }

    public synchronized boolean isAllowed(Integer eineSichtTid) {
        boolean result = false;
        if (this.containsItemWithId(eineSichtTid)) {
            AbstractSicht sicht = (AbstractSicht)this.getById(eineSichtTid);
            result = sicht.isAllowed();
        }
        return result;
    }

    public synchronized Sichtgruppe getGruppe(Hashtable formular, HashMap map, FieldContainer individualFields, String beschreibung, Field.Art art, List<Integer> sichtentids, String relation, int feldZeilenanzahl, String defaultStand, String mandantenID) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, SichtException, NoMainEntryException, TemplateException, IOException {
        Sichtgruppe sichtgruppe = null;
        if (art != Field.Art.id_4_Institutionsdialog && art != Field.Art.id_6_Institutionsdialog_fuer_Lehreinheiten && art != Field.Art.id_7_Institutionsdialog_fuer_Lehreinheiten_ohne_Einschr_Userrechte && art != Field.Art.id_12_Sicht) {
            throw new IllegalArgumentException("Kann Sichten nicht f\u00fcr art " + art.getIntValue() + " ermitteln");
        }
        if (art == Field.Art.id_4_Institutionsdialog) {
            sichtgruppe = this.standardOrganigrammGruppe;
        }
        if (art == Field.Art.id_6_Institutionsdialog_fuer_Lehreinheiten) {
            sichtgruppe = this.oldLehreMitUserrechtenGruppe;
        }
        if (art == Field.Art.id_7_Institutionsdialog_fuer_Lehreinheiten_ohne_Einschr_Userrechte) {
            sichtgruppe = this.oldLehreOhneUserrechteGruppe;
        }
        if (art == Field.Art.id_12_Sicht) {
            if (sichtentids.isEmpty()) {
                throw new SichtException("Keine Sichten gefunden - kein Rechteproblem DETAILS: relation war " + relation);
            }
            String maxList = StringUtils.toCommaList(sichtentids);
            LinkedList<Integer> disallowedTids = new LinkedList<Integer>();
            for (Integer sichtenTid : sichtentids) {
                if (this.isAllowed(sichtenTid)) continue;
                disallowedTids.add(sichtenTid);
            }
            sichtentids.removeAll(disallowedTids);
            if (sichtentids.isEmpty()) {
                StringBuffer buf = new StringBuffer("Sie haben keine Rechte f\u00fcr eine der folgenden Sichten:  ");
                try {
                    String stmt = "select tid,name,art from sichten where tid in (" + maxList + ")";
                    SuperX_el el = ServletUtils.executeALL_el(null, null, "Sichtennamen lesen", stmt, mandantenID, true);
                    for (SxResultRow aRow : el.getResultSet()) {
                        buf.append(String.valueOf(aRow.get(1)) + " (" + String.valueOf(aRow.get(2)) + " tid:" + String.valueOf(aRow.get(0)) + "),");
                    }
                }
                catch (NoClassDefFoundError e) {
                    buf.append(" tids:" + maxList + " ");
                }
                StringUtils.removeLastChar(buf);
                buf.append(". ");
                throw new SichtException(buf.toString());
            }
            sichtgruppe = new Sichtgruppe("Sichtgruppe " + beschreibung);
            boolean isFirstInGroup = true;
            for (Integer sichtenTid : sichtentids) {
                AbstractSicht s = (AbstractSicht)this.getById(sichtenTid);
                AbstractSicht s2 = (AbstractSicht)s.clone();
                if (isFirstInGroup) {
                    s2.setFirstInGroup(true);
                    isFirstInGroup = false;
                }
                sichtgruppe.add(s2);
            }
            sichtgruppe.setMultiSelection(feldZeilenanzahl > 1);
            sichtgruppe.setSelectedSicht(sichtentids.get(0));
        }
        if (sichtgruppe == null) {
            throw new IllegalArgumentException("Keine Sicht gefunden");
        }
        sichtgruppe.setStand(formular, map, individualFields, defaultStand);
        sichtgruppe.makeSureSelectedSichtIsOK(formular, map, individualFields);
        return sichtgruppe;
    }

    public Collection<String> getSichtenArten() {
        TreeSet<String> result = new TreeSet<String>();
        for (AbstractSicht sicht : this) {
            result.add(sicht.getArt());
        }
        return result;
    }
}

