/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.tree.HideableNodesTreeModel;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.memtext.util.TreeUtils;
import de.superx.common.ItemComparator;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectableItemTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final int PREORDER_ENUM = 1;
    public static final int BREADTHFIRST_ENUM = 2;
    public static final int DEPTHFIRST_ENUM = 3;

    public SelectableItemTree() {
        HideableNodesTreeModel model = new HideableNodesTreeModel(SelectableItemTree.getARootNode());
        model.setFilterActive(true);
        this.setModel(model);
    }

    public static SelectableItemNode getARootNode() {
        SelectableItem item = new SelectableItem("xxxxxx-xxxxxx@", "alles");
        item.setLehre(true);
        item.setAllowed(false);
        return new SelectableItemNode(item);
    }

    public boolean containsElements() {
        boolean result = true;
        if (this.getRoot().getChildCount() == 0) {
            result = false;
        } else {
            SelectableItemNode child1 = (SelectableItemNode)this.getRoot().getChildAt(0);
            if (child1.getName().startsWith("Keine Auswahl")) {
                result = false;
            }
            if (this.getRoot().getChildCount() == 1 && child1.getKey().toString().equals("")) {
                result = false;
            }
        }
        return result;
    }

    public void add(SelectableItemNode itemnode) {
        ((SelectableItemNode)this.getModel().getRoot()).add(itemnode);
    }

    public boolean containsItemWithId(String selectedKey) {
        boolean result = false;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null) {
                if (selectedKey != null) continue;
                result = true;
                continue;
            }
            if (!node.getId().toString().equals(selectedKey)) continue;
            result = true;
        }
        return result;
    }

    public String getAllKeys() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null || node.getId().equals("") || node.getId().toString().equals("xxxxxx-xxxxxx@")) continue;
            if (node.getId() instanceof String) {
                result.append("'" + String.valueOf(node.getId()) + "',");
                continue;
            }
            result.append(String.valueOf(node.getId()) + ",");
        }
        StringUtils.removeLastChar(result);
        return result.toString();
    }

    public SelectableItemNode getById(String selectedKey) {
        SelectableItemNode result = null;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null) {
                if (selectedKey != null) continue;
                result = node;
                break;
            }
            if (!node.getId().toString().equals(selectedKey)) continue;
            result = node;
            break;
        }
        return result;
    }

    public String getSuitingKeyString(String muster) {
        StringBuffer result = new StringBuffer();
        String m = StringUtils.replace(muster, "*", ".*");
        boolean isFirst = true;
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.isTemporary() || node.getId() == null || !node.getId().toString().matches(m)) continue;
            if (!isFirst) {
                result.append("|");
            } else {
                isFirst = false;
            }
            result.append(node.getId().toString());
        }
        return result.toString();
    }

    public void removeTempElements() {
        LinkedList<SelectableItemNode> tempNodes = new LinkedList<SelectableItemNode>();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (!node.isTemporary()) continue;
            tempNodes.add(node);
        }
        for (SelectableItemNode tempNode : tempNodes) {
            tempNode.removeFromParent();
        }
    }

    public SelectableItemNode getRoot() {
        return (SelectableItemNode)this.getModel().getRoot();
    }

    public Object clone() throws CloneNotSupportedException {
        SelectableItemTree cl = new SelectableItemTree();
        SelectableItemTree.cloneNodes((SelectableItemNode)this.getModel().getRoot(), (SelectableItemNode)cl.getModel().getRoot());
        return cl;
    }

    public static void cloneNodes(SelectableItemNode sourceN, SelectableItemNode targetN) {
        Enumeration<TreeNode> en = sourceN.children();
        while (en.hasMoreElements()) {
            SelectableItemNode aChild = (SelectableItemNode)en.nextElement();
            SelectableItemNode cl = (SelectableItemNode)aChild.clone();
            targetN.add(cl);
            SelectableItemTree.cloneNodes(aChild, cl);
        }
    }

    public Collection<SelectableItemNode> getElements(int enumType, boolean isHiddenWanted) {
        LinkedList<SelectableItemNode> result = new LinkedList<SelectableItemNode>();
        SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
        if (this.getSelectionCount() > 0) {
            startNode = (SelectableItemNode)this.getSelectionPath().getLastPathComponent();
        }
        Enumeration<TreeNode> en = null;
        if (enumType < 1 || enumType > 3) {
            throw new IllegalArgumentException("Ung\u00fcltiger Enumtype");
        }
        if (enumType == 1) {
            en = startNode.preorderEnumeration();
        }
        if (enumType == 2) {
            en = startNode.breadthFirstEnumeration();
        }
        if (enumType == 3) {
            en = startNode.depthFirstEnumeration();
        }
        if (en != null) {
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                result.add(node);
            }
        }
        return result;
    }

    public Collection getAllElements() {
        LinkedList<SelectableItemNode> result = new LinkedList<SelectableItemNode>();
        SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
        Enumeration<TreeNode> en = startNode.preorderEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.isRoot()) continue;
            result.add(node);
        }
        return result;
    }

    public void setSelectedKey(String selectedKey) {
        this.clearSelection();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).preorderEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (!EqualsUtil.areEqual(node.getId(), selectedKey)) continue;
            this.setSelectionPath(new TreePath(node.getPath()));
            break;
        }
        if (this.getSelectionCount() == 0) {
            throw new IllegalArgumentException("Kein Knoten mit key " + selectedKey + " gefunden");
        }
    }

    public void setSelectedKeys(String keys) throws IllegalArgumentException {
        if (keys == null || keys.indexOf("|") == -1) {
            throw new IllegalArgumentException("Mehrere keys mit | getrennt erwartet, nicht " + keys);
        }
        this.clearSelection();
        StringTokenizer st = new StringTokenizer(keys, "|");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            boolean isOk = false;
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).preorderEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                if (!EqualsUtil.areEqual(node.getId(), key)) continue;
                isOk = true;
                this.addSelectionPath(new TreePath(node.getPath()));
                break;
            }
            if (isOk) continue;
            throw new IllegalArgumentException("Kein Knoten mit key " + key + " gefunden");
        }
    }

    public Collection getSelectedItems() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < this.getSelectionCount(); ++i) {
            list.add(this.getSelectionPaths()[i].getLastPathComponent());
        }
        return list;
    }

    public Collection getSelectedItemsSortByKey() {
        TreeSet ts = new TreeSet(new ItemComparator("key"));
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByName() {
        TreeSet ts = new TreeSet(new ItemComparator("name"));
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByStrukturInt() {
        TreeSet ts = new TreeSet(new ItemComparator("strukturint"));
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public Collection getSelectedItemsSortByStrukturStr() {
        TreeSet ts = new TreeSet(new ItemComparator("strukturstr"));
        ts.addAll(this.getSelectedItems());
        return ts;
    }

    public String getLongDebugString() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            for (int i = 0; i < node.getLevel(); ++i) {
                result.append(" ");
            }
            result.append(String.valueOf(node.getId()) + "\n");
        }
        return result.toString();
    }

    public String getDebugString() {
        StringBuffer result = new StringBuffer();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            result.append("Level" + node.getLevel() + ": " + String.valueOf(node.getId()) + " -");
        }
        return result.toString();
    }

    public String getAllNeededKeysList() {
        Object result = "";
        if (this.getSelectionCount() == 0) {
            result = TreeUtils.getSubordinateKeyList((DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot(), true, true);
        } else {
            for (int i = 0; i < this.getSelectionCount(); ++i) {
                SelectableItemNode selNode = (SelectableItemNode)this.getSelectionPaths()[i].getLastPathComponent();
                if (i > 0) {
                    result = (String)result + ",\n";
                }
                result = (String)result + TreeUtils.getSubordinateKeyList(selNode, true, true);
            }
        }
        return "(" + (String)result + ")";
    }

    public void updateLevelFromSelection() {
        if (this.getSelectionCount() > 0) {
            for (int i = 0; i < this.getSelectionCount(); ++i) {
                SelectableItemNode node = (SelectableItemNode)this.getSelectionPaths()[i].getLastPathComponent();
                node.setLevelFromSelection(0);
            }
        } else {
            SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
            startNode.setLevelFromSelection(-1);
        }
    }
}

