/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientBsegHoh
extends AbstractWebserviceClient {
    private Document configDocument;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private String xmlConfig;
    private String url;
    private String soap;
    private String outfilename;
    private File tmpFile;
    private File outFileBSEG;
    private File outFileBKPF;
    private String jahr;
    private int jahrint;
    private PrintWriter fwBSEG;
    private PrintWriter fwBKPF;
    private BufferedWriter bfwBSEG;
    private BufferedWriter bfwBKPF;
    private Calendar cal = Calendar.getInstance();
    private Calendar targetCal = Calendar.getInstance();
    private StringBuilder bseg = new StringBuilder();
    private StringBuilder bkpf = new StringBuilder();

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientBesegHoh Version 1.0.2");
        WebserviceClientBsegHoh tc = new WebserviceClientBsegHoh();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_jahr, GetOpts.Options.opt_out});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            logger.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, "url");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        logger.fine("URL:" + this.url);
        System.out.println("URL:" + this.url);
        n = XMLUtils.getFirstNode(this.configDocument, "soap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.soap);
        this.initOutFiles();
        int i = 0;
        int jahrint = Integer.parseInt(this.jahr);
        while (this.cal.get(1) == jahrint && this.cal.before(this.targetCal)) {
            Object msg = "starte Aufruf " + ++i + " (" + this.getDateString() + ") ";
            String tmpsoap = this.getTmpSoap();
            logger.fine("SOAP Aufruf:\n" + tmpsoap);
            System.out.print((String)msg);
            this.tmpFile = this.createSoapFile(tmpsoap, this.url);
            msg = " - empfangen ";
            if (!this.isDeleteTmpXmlFileWanted) {
                msg = (String)msg + " (" + String.valueOf(this.tmpFile) + ")";
            }
            msg = (String)msg + " " + DateUtils.getNowString();
            System.out.println((String)msg);
            if (this.isReplyOk(this.tmpFile)) {
                this.readData();
                if (this.bseg.length() > 0) {
                    this.bfwBSEG.write(this.bseg.toString());
                    this.bfwBSEG.flush();
                }
                if (this.bkpf.length() > 0) {
                    this.bfwBKPF.write(this.bkpf.toString());
                    this.bfwBKPF.flush();
                }
                if (!this.isDeleteTmpXmlFileWanted) continue;
                this.tmpFile.delete();
                continue;
            }
            msg = "Error: Aufruf von Webservice f\u00fcr Beseg  (" + this.xmlConfig + ") fehlgeschlagen";
            System.out.println((String)msg);
            System.out.println(StringUtils.readFile(this.tmpFile));
            logger.severe((String)msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
        this.closeFile();
    }

    private String getDateString() {
        int month = this.cal.get(2) + 1;
        String monthstr = "" + month;
        if (month < 10) {
            monthstr = "0" + month;
        }
        int day = this.cal.get(5);
        String daystring = "" + day;
        if (day < 10) {
            daystring = "0" + day;
        }
        String result = this.cal.get(1) + "-" + monthstr + "-" + daystring;
        return result;
    }

    private String getTmpSoap() {
        String tempsoap = this.soap;
        String start = this.getDateString();
        Object end = this.getDateString();
        if (this.cal.get(1) != this.jahrint) {
            end = this.jahr + "-12-31";
        }
        tempsoap = tempsoap.replaceAll("XXSTARTXX", start);
        tempsoap = tempsoap.replaceAll("XXENDEXX", (String)end);
        this.cal.add(6, 1);
        return tempsoap;
    }

    private void readConfig() throws IOException, SAXException {
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfilename = GetOpts.getValue(GetOpts.Options.opt_out);
        this.jahr = GetOpts.getValue(GetOpts.Options.opt_jahr);
        this.jahrint = Integer.parseInt(this.jahr);
        this.cal.set(this.jahrint, 0, 1);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString());
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        logger.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void initOutFiles() throws Exception {
        this.outFileBSEG = new File(this.outfilename);
        if (this.outFileBSEG.exists()) {
            this.outFileBSEG.delete();
        }
        this.outFileBKPF = new File(StringUtils.replace(this.outfilename, ".", "_bkpf."));
        this.fwBSEG = new PrintWriter(this.outFileBSEG);
        this.fwBKPF = new PrintWriter(this.outFileBKPF);
        this.bfwBSEG = new BufferedWriter(this.fwBSEG);
        this.bfwBKPF = new BufferedWriter(this.fwBKPF);
    }

    private void closeFile() throws Exception {
        this.bfwBSEG.close();
        this.fwBSEG.close();
        this.bfwBKPF.close();
        this.fwBKPF.close();
        if (this.isDeleteTmpXmlFileWanted && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    private void readData() throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        this.bseg.setLength(0);
        this.bkpf.setLength(0);
        boolean getDataBSEG = false;
        boolean getDataBKPF = false;
        boolean isBSEG = false;
        boolean isBKPF = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (name.equals("EX_BSEG")) {
                        isBSEG = true;
                    }
                    if (isBSEG && this.isRelevantNodeNameBSEG(name)) {
                        getDataBSEG = true;
                    }
                    if (name.equals("EX_BKPF")) {
                        isBKPF = true;
                    }
                    if (!isBKPF || !this.isRelevantNodeNameBKPF(name)) break;
                    getDataBKPF = true;
                    break;
                }
                case 4: {
                    if (isBSEG && getDataBSEG && !parser.isWhiteSpace()) {
                        this.bseg.append(WebserviceClientBsegHoh.purge(parser.getText(), true));
                    }
                    if (!isBKPF || !getDataBKPF || parser.isWhiteSpace()) break;
                    this.bkpf.append(WebserviceClientBsegHoh.purge(parser.getText(), true));
                    break;
                }
                case 2: {
                    String name = parser.getLocalName();
                    if (name.equals("EX_BSEG")) {
                        isBSEG = false;
                    }
                    if (isBSEG && getDataBSEG && this.isRelevantNodeNameBSEG(name)) {
                        getDataBSEG = false;
                        this.bseg.append("^");
                    }
                    if (name.equals("EX_BKPF")) {
                        isBKPF = false;
                    }
                    if (isBKPF && getDataBKPF && this.isRelevantNodeNameBKPF(name)) {
                        getDataBKPF = false;
                        this.bkpf.append("^");
                    }
                    if (isBSEG && name.equals("item")) {
                        this.bseg.append("\n");
                    }
                    if (!isBKPF || !name.equals("item")) break;
                    this.bkpf.append("\n");
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
    }

    private boolean isRelevantNodeNameBSEG(String name) {
        return name.equals("GJAHR") || name.equals("BELNR") || name.equals("BUZEI") || name.equals("ZUONR") || name.equals("ANLN1");
    }

    private boolean isRelevantNodeNameBKPF(String name) {
        return name.equals("GJAHR") || name.equals("BELNR") || name.equals("XBLNR");
    }
}

