/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;

public class SxJasperCompiler {
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.SxJasperCompiler <<jrxml-Datei>>  \n---------------------------------------------------";

    public static void go(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException {
        if (args.length == 0) {
            throw new IllegalArgumentException("Parameter jrxml-Datei erfoderlich");
        }
        String jrxmlFileName = args[0];
        String jasperFileName = FileUtils.getFileNameWithoutSuffix(jrxmlFileName) + ".jasper";
        try {
            long start = System.currentTimeMillis();
            if (!jrxmlFileName.equals("")) {
                JasperCompileManager.compileReportToFile((String)jrxmlFileName, (String)jasperFileName);
                System.out.println("File " + jasperFileName + " created, compile time : " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Compile erfolgreich beendet");
    }

    public static void main(String[] args) {
        try {
            SxJasperCompiler.go(args);
        }
        catch (Exception ex) {
            System.err.println("Aufruf fehlgeschlagen.\n" + String.valueOf(ex));
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

