/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.bin.Doschema;
import de.superx.bin.SxConnection;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.SxTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Doquery {
    private static Connection myDb;
    private static Statement st;
    private static DatabaseMetaData dbmd;
    private static boolean done;
    private static String delim;
    private static String header;
    private static Doschema.Format outFormat;
    private static String logfile;
    private static String tabelle;
    private static String dbpropfile;
    private static SxConnection myConnection;
    private static String db_driver;
    private static String outfile;
    private static Logger logger;
    private static String usage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void go(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException, IllegalArgumentException {
        if (args.length <= 0) {
            throw new IllegalArgumentException("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
        }
        logfile = args[0].trim();
        File f = new File(logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        String _sql = "";
        if (args.length > 1) {
            dbpropfile = args[1].trim();
        } else {
            logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
            System.exit(1);
        }
        if (args.length > 2) {
            _sql = args[2].trim();
            if (_sql.length() > 0) {
                if (_sql.startsWith("\"")) {
                    _sql = _sql.substring(1, _sql.length());
                }
                if (_sql.endsWith("\"")) {
                    _sql = _sql.substring(0, _sql.length() - 1);
                }
            }
        } else {
            logger.severe("Mindestens drei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties, sql-String) erfoderlich");
            System.exit(1);
        }
        if (args.length > 3) {
            outFormat = Doschema.Format.valueOf(args[3].trim().toLowerCase());
        }
        if (args.length > 4) {
            delim = args[4].trim();
        }
        if (args.length > 5) {
            header = args[5].trim();
        }
        if (args.length > 6) {
            outfile = args[6].trim();
        }
        if (delim.equals("")) {
            delim = "^";
        }
        if (!outfile.equals("")) {
            try {
                FileWriter f1 = new FileWriter(outfile);
                f1.write("");
                f1.close();
            }
            catch (IOException e) {
                logger.severe("Fehler beim Erstellen der Datei " + outfile);
            }
        }
        Doquery.getConnection(logger, dbpropfile);
        SxTransformer myTransformer = null;
        if (Doquery.myConnection.m_DriverClass == SxConnection.DriverClass.dc_postgre && !outfile.equals("") && outFormat == Doschema.Format.txt && !header.equals("true")) {
            logger.info("Unload with Postgres Boost mode");
            PreparedStatement l_stmt = null;
            Statement l_stmtFetch = null;
            Statement l_stmtClose = null;
            ResultSet l_rset = null;
            ResultSetMetaData l_mdat = null;
            try {
                st = myDb.createStatement();
                if (_sql.indexOf(";") > 0) {
                    String einzelsql = "";
                    StringTokenizer tk = new StringTokenizer(_sql, ";");
                    while (tk.hasMoreTokens()) {
                        einzelsql = tk.nextToken();
                        if (!tk.hasMoreTokens()) continue;
                        st.execute(einzelsql);
                    }
                    _sql = einzelsql;
                }
                logger.info("Print Result of: " + _sql);
                st.execute("Begin;");
                try {
                    l_stmt = myConnection.prepareStatement("DECLARE FOO CURSOR FOR " + _sql);
                    l_stmt.execute();
                    l_stmtFetch = myConnection.prepareStatement("FETCH FORWARD 10000 FROM FOO");
                    l_rset = l_stmtFetch.executeQuery();
                    l_mdat = l_rset.getMetaData();
                    while (l_rset.next()) {
                        myTransformer = outfile.equals("") ? new SxTransformer(logger, System.out) : new SxTransformer(logger, new FileWriter(outfile, true));
                        myTransformer.setDelim(delim);
                        myTransformer.setHeader(header);
                        myTransformer.setOutrs(l_rset);
                        myTransformer.setOutrsmd(l_mdat);
                        myTransformer.printResult(outFormat.name());
                        l_rset = l_stmtFetch.executeQuery();
                    }
                    l_stmtClose = myConnection.prepareStatement("CLOSE FOO");
                    l_stmtClose.execute();
                }
                finally {
                    if (l_rset != null) {
                        l_rset.close();
                    }
                    if (l_stmt != null) {
                        l_stmt.close();
                    }
                    if (l_stmtFetch != null) {
                        l_stmtFetch.close();
                    }
                    if (l_stmtClose != null) {
                        l_stmtClose.close();
                    }
                }
            }
            catch (SQLException l_se) {
                logger.severe("Fehler beim SQL " + _sql);
                l_se.printStackTrace();
            }
            st = myDb.createStatement();
            st.execute("commit;");
            myConnection.close();
        } else {
            SxJdbcClient myClient = new SxJdbcClient(logger, dbpropfile, _sql);
            myClient.Rs_executeALL();
            logger.info("Getting resultset");
            ResultSet myrs = myClient.getRs();
            if (myrs != null && myrs.next()) {
                if (outfile.equals("")) {
                    myTransformer = new SxTransformer(logger, System.out);
                    myClient.setLogAllResultSetsToConsole(true);
                } else {
                    myTransformer = new SxTransformer(logger, new FileWriter(outfile));
                }
                myTransformer.setDelim(delim);
                myTransformer.setHeader(header);
                myTransformer.setOutrs(myrs);
                myTransformer.setOutrsmd(myClient.getRsmd());
                logger.info("Print Result of: " + _sql);
                myTransformer.printResult(outFormat.name());
            }
            myClient.close();
        }
        logger.info("doquery erfolgreich beendet");
    }

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Java-Programm f\u00fchrt einen SQL-Ausdruck aus und gibt das Ergebnis aus.\n");
        System.out.println("Gebrauch:\n java doquery <Pfad zu logger-properties> <pfad zu db.properties> <sql-Ausdruck> <Ausgabeformat (txt | html | xml)>(optional) <delimiter> <mit Spalten\u00fcberschriften (true | false)>(optional) <Ausgabedatei>(optional)\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Doquery.go(args);
        }
        catch (Exception ex) {
            System.err.println("Doquery Aufruf fehlgeschlagen.\n" + String.valueOf(ex));
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public static void getConnection(Logger logger, String propFile) throws SQLException {
        myConnection = new SxConnection();
        myConnection.setPropfile(propFile);
        logger.config("Starting Connection...");
        try {
            myDb = myConnection.getConnection();
            st = myDb.createStatement();
            dbmd = myDb.getMetaData();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Keine DB-Verbindung: " + e.toString());
            throw new SQLException("Keine DB-Verbindung: " + e.toString());
        }
        db_driver = Doquery.myConnection.m_DriverClass.stringValue();
    }

    static {
        done = false;
        delim = "^";
        header = "false";
        outFormat = Doschema.Format.txt;
        logfile = "../conf/logging.properties";
        tabelle = "";
        dbpropfile = "../conf/db.properties";
        myConnection = null;
        outfile = "";
        logger = Logger.getLogger(Doquery.class.toString());
        usage = "-------------------------------------\nGebrauch: java de.superx.SimpleTransform -logger=<<Pfad zu logging.properties>> -IN=<<xml-Datei>> -XSL=<<xsl-Datei>> -method=<<xml |html|text>>(optional) -param=<<Parameter>>(optional) -OUT=<<Ausgabedatei>>(optional) \n---------------------------------------------------";
    }
}

