/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.sqlgeneration;

import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.models.Condition;
import de.superx.bianalysis.models.CriteriaGroup;
import de.superx.bianalysis.sqlgeneration.SqlQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class AttributeGroupQueryBuilder {
    public static final String DEFAULT_LOGIC_CRITERIA_GROUP = "AND";

    public static StringJoiner buildConditionClause(List<String> caseParams, List<Integer> argTypes, CriteriaGroup group) {
        StringJoiner joinerConditions = null;
        joinerConditions = group.logic != null ? new StringJoiner(" " + group.logic + " ") : new StringJoiner(" AND ");
        for (Object obj : group.conditions) {
            if (Condition.isCondition(obj)) {
                Condition condition = Condition.fromMap(obj);
                switch (condition.operator.toUpperCase()) {
                    case "BETWEEN": {
                        if (condition.values == null || condition.values.size() != 2) {
                            throw new FaultyMetadataException("BETWEEN requires exactly two values: " + condition.column);
                        }
                        joinerConditions.add(condition.column + " BETWEEN ? AND ?");
                        caseParams.add(condition.values.get(0));
                        caseParams.add(condition.values.get(1));
                        argTypes.add(12);
                        argTypes.add(12);
                        break;
                    }
                    case "=": 
                    case "!=": {
                        joinerConditions.add(condition.column + " " + condition.operator + " ?");
                        caseParams.add(condition.value);
                        argTypes.add(12);
                        break;
                    }
                    case "IN": 
                    case "NOT IN": {
                        StringJoiner inJoiner = new StringJoiner(" ");
                        inJoiner.add(condition.column);
                        inJoiner.add(condition.operator + " (");
                        StringJoiner joiner = new StringJoiner(", ");
                        for (String value : condition.values) {
                            joiner.add("?");
                            caseParams.add(value);
                            argTypes.add(12);
                        }
                        inJoiner.add(joiner.toString());
                        joinerConditions.add(inJoiner.toString() + " )");
                        break;
                    }
                    case "<": 
                    case ">": 
                    case ">=": 
                    case "<=": {
                        boolean isNumber = true;
                        try {
                            Double.parseDouble(condition.value);
                        }
                        catch (NumberFormatException e) {
                            isNumber = false;
                        }
                        if (isNumber) {
                            String check = "%s ~ E'^-?\\\\d+$' AND %s::int %s ?";
                            joinerConditions.add(String.format(check, condition.column, condition.column, condition.operator));
                            caseParams.add(condition.value);
                            argTypes.add(4);
                            break;
                        }
                        joinerConditions.add(condition.column + " " + condition.operator + " ?");
                        caseParams.add(condition.value);
                        argTypes.add(12);
                        break;
                    }
                    default: {
                        throw new FaultyMetadataException("Unsupported operator: " + condition.operator);
                    }
                }
                continue;
            }
            if (!CriteriaGroup.isGroup(obj)) continue;
            CriteriaGroup subGroup = CriteriaGroup.fromMap(obj);
            StringJoiner subClause = AttributeGroupQueryBuilder.buildConditionClause(caseParams, argTypes, subGroup);
            joinerConditions.add("(" + String.valueOf(subClause) + ")");
        }
        return joinerConditions;
    }

    public static SqlQuery buildColumnQuery(List<CriteriaGroup> groups, String tableName, boolean isSortOrder, String columnname) {
        ArrayList<String> caseParams = new ArrayList<String>();
        StringBuilder caseBuilder = new StringBuilder("CASE ");
        ArrayList<Integer> argTypes = new ArrayList<Integer>();
        int sortOrderColumnNumber = 1;
        for (CriteriaGroup group : groups) {
            if (group.conditions == null) continue;
            caseBuilder.append("WHEN ");
            StringJoiner joinerConditions = AttributeGroupQueryBuilder.buildConditionClause(caseParams, argTypes, group);
            caseBuilder.append(joinerConditions.toString());
            caseBuilder.append(" THEN ? ");
            if (isSortOrder) {
                caseParams.add(String.valueOf(sortOrderColumnNumber++));
                argTypes.add(4);
                continue;
            }
            caseParams.add(group.caption);
            argTypes.add(12);
        }
        caseBuilder.append("ELSE ? END");
        if (isSortOrder) {
            caseParams.add(String.valueOf(sortOrderColumnNumber++));
            argTypes.add(4);
        } else {
            String emptyLabel = groups.stream().filter(p -> p.isElse).findFirst().map(p -> p.caption).orElse("n.v.");
            caseParams.add(emptyLabel);
            argTypes.add(12);
        }
        String updateSql = "UPDATE %s SET %s = %s".formatted(tableName, columnname, caseBuilder);
        Object[] params = caseParams.toArray();
        int[] types = argTypes.stream().mapToInt(Integer::intValue).toArray();
        return new SqlQuery(updateSql, params, types);
    }

    public static SqlQuery buildValidationQuery(String tableName, String colList, List<CriteriaGroup> groups) {
        StringJoiner selectStatements = new StringJoiner(" INTERSECT ");
        ArrayList<String> caseParams = new ArrayList<String>();
        ArrayList<Integer> argTypes = new ArrayList<Integer>();
        for (CriteriaGroup group : groups) {
            if (group.isElse) continue;
            StringBuilder criteraStmt = new StringBuilder("SELECT " + colList);
            StringJoiner selectParams = new StringJoiner(", ");
            criteraStmt.append(selectParams);
            criteraStmt.append(" FROM ");
            criteraStmt.append(tableName);
            criteraStmt.append(" WHERE ");
            StringJoiner joinerConditions = AttributeGroupQueryBuilder.buildConditionClause(caseParams, argTypes, group);
            criteraStmt.append(joinerConditions.toString());
            selectStatements.add(criteraStmt);
        }
        Object[] params = caseParams.toArray();
        int[] types = argTypes.stream().mapToInt(Integer::intValue).toArray();
        return new SqlQuery(selectStatements.toString(), params, types);
    }
}

