/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository.dto;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.jdbc.core.JdbcTemplate;

@Table(schema="metadata", value="measure")
public class MeasureDto
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", readOnly=true, visibleInSimplifiedForm=false)
    public Identifier id;
    @EntityDescriptor
    @DynamicFieldType(label="Kennzahlenbezeichnung")
    public String caption;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea)
    public String description;
    @DynamicFieldType(label="Faktentabelle", readOnly=true, visibleInSimplifiedForm=true)
    @TableRef(schema="metadata", table="facttable", keyField="id", labelField="caption")
    @Column(value="facttable_id")
    public Identifier factTableId;
    @DynamicFieldType(label="Spaltenname", readOnly=true)
    public String columnname;
    @DynamicFieldType(label="Filter", visibleInSimplifiedForm=false, readOnly=true)
    @TableRef(schema="metadata", table="measure_filter", keyField="id", labelField="caption")
    @Column(value="measure_filter_id")
    public Identifier measureFilterId;
    @DynamicFieldType(label="Aggregationstyp", readOnly=true)
    @Column(value="aggregation_type")
    public String aggregationType;
    @DynamicFieldType(label="Datentyp", visibleInSimplifiedForm=false, readOnly=true)
    @Column(value="measure_type")
    public String measureType;
    @DynamicFieldType(label="Auslieferungsversion", visibleInSimplifiedForm=false)
    @Column(value="default_release")
    public String defaultRelease;
    @DynamicFieldType(label="Ausgeblendet", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, visibleInSimplifiedForm=false)
    @Column(value="is_hidden")
    public Boolean isHidden;

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        List<Item> items = new ArrayList<Item>();
        if (fieldName.equals("aggregationType")) {
            items.add(new Item("Summe (sum)", "sum"));
            items.add(new Item("Anzahl (count)", "count"));
            items.add(new Item("Anzahl unterschiedlicher Werte (distinct-count)", "distinct-count"));
            items.add(new Item("Durchschnitt (avg)", "avg"));
            items.add(new Item("Minimum (min)", "min"));
            items.add(new Item("Maximum (max)", "max"));
            items.add(new Item("Standardabweichung (std)", "std"));
            items.add(new Item("Varianz (var)", "var"));
        } else if (fieldName.equals("measureType")) {
            items.add(new Item("Ganzzahl", "IntegerColumn"));
            items.add(new Item("Dezimalzahl", "DecimalColumn"));
        } else if (fieldName.equals("columnname")) {
            if (this.factTableId == null) {
                return items;
            }
            JdbcTemplate jt = new JdbcTemplate(ds);
            String queryTableName = "SELECT tablename FROM metadata.facttable WHERE id = ?";
            String tableName = null;
            try {
                tableName = (String)jt.queryForObject(queryTableName, String.class, new Object[]{this.factTableId.composedId});
                if (tableName == null || tableName.isEmpty()) {
                    System.err.println("No table name found for id: " + String.valueOf(this.factTableId));
                    return items;
                }
                String sql = "SELECT column_name FROM information_schema.columns WHERE table_schema = ? AND table_name = ? ORDER BY ordinal_position";
                List columnNames = jt.queryForList(sql, String.class, new Object[]{"presentation", tableName});
                if (columnNames == null || columnNames.isEmpty()) {
                    return items;
                }
                for (String columnName : columnNames) {
                    if (columnName == null || columnName.isEmpty()) continue;
                    items.add(new Item(columnName, columnName));
                }
            }
            catch (DataAccessException dae) {
                System.err.println("Database error while retrieving table or columns: " + dae.getMessage());
            }
            catch (Exception ex) {
                System.err.println("Unexpected error: " + ex.getMessage());
            }
        } else if (fieldName.equals("defaultRelease")) {
            items = DbMetaAdapter.getDefaultReleaseValues(ds);
        }
        return items;
    }
}

