/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.CriteriaGroup;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.EntityBase;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.EntityDescriptor;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.Item;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(schema="metadata", value="dimension_attribute")
public class AttributeDto
extends EntityBase {
    @Id
    @DynamicFieldType(label="ID", readOnly=true, visibleInSimplifiedForm=false)
    public Identifier id;
    @EntityDescriptor
    @DynamicFieldType(label="Attributsbezeichnung")
    public String caption;
    @DynamicFieldType(label="Beschreibung", editControlType=FieldType.TextArea)
    public String description;
    @DynamicFieldType(label="Dimension", readOnly=true, visibleInSimplifiedForm=true)
    @TableRef(schema="metadata", table="dimension", keyField="id", labelField="caption")
    @Column(value="dimension_id")
    public Identifier dimensionId;
    @DynamicFieldType(label="Spaltenname", readOnly=true)
    public String columnname;
    @DynamicFieldType(label="Sortierspalte", readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="sort_order_column")
    public String sortOrderColumn;
    @DynamicFieldType(label="Filter-Auswahl", readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="filter_selection")
    public String filterSelection;
    @DynamicFieldType(label="Hierarchie", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, readOnly=true, visibleInSimplifiedForm=false)
    @Column(value="hierarchical_filter")
    public Boolean hierarchicalFilter;
    @DynamicFieldType(label="Ausgeblendet", editControlType=FieldType.Select, columnType=ColumnType.BooleanColumnBiAnalysis, visibleInSimplifiedForm=false)
    @Column(value="is_hidden")
    public Boolean isHidden;
    @DynamicFieldType(label="Gemeinsame Attribute", readOnly=true, visibleInSimplifiedForm=true)
    @TableRef(schema="metadata", table="dimension_attribute", keyField="id", labelField="caption")
    @Column(value="conformed")
    public String attrConformedId;
    @DynamicFieldType(label="Auslieferungsversion", visibleInSimplifiedForm=false)
    @Column(value="default_release")
    public String defaultRelease;
    @DynamicFieldType(label="Position", visibleInSimplifiedForm=false)
    public Integer position;
    @DynamicFieldType(label="Criteria Groups", editControlType=FieldType.TextArea, readOnly=false, visibleInSimplifiedForm=false)
    @Column(value="criteria_groups")
    public ArrayNode criteriaGroups;

    @Override
    public boolean canBeCreatedByUser() {
        return false;
    }

    @Override
    public boolean canBeDeletedByUser() {
        return false;
    }

    @Override
    public List<Item> getCellSpecificItems(String fieldName, DataSource ds) {
        List<Item> items = new ArrayList<Item>();
        if (fieldName.equals("filterSelection")) {
            items.add(new Item("Kompletter Wertebereich", "show_all"));
            items.add(new Item("Tats\u00e4chlich vorkommende Werte", "show_existing_only"));
            items.add(new Item("Von erster bis letzter Auspr\u00e4gung", "show_range"));
        } else if (fieldName.equals("defaultRelease")) {
            items = DbMetaAdapter.getDefaultReleaseValues(ds);
        }
        return items;
    }

    @JsonIgnore
    public List<CriteriaGroup> readCriteriaGroups() {
        ArrayList<CriteriaGroup> groups = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        try {
            groups = (List)mapper.convertValue((Object)this.criteriaGroups, (TypeReference)new TypeReference<List<CriteriaGroup>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON array to CriteriaGroup list", e);
        }
        return groups;
    }

    @JsonIgnore
    public String getEmptyLabel() {
        return this.readCriteriaGroups().stream().filter(p -> p.isElse).findFirst().map(p -> p.caption).orElse("n.v.");
    }

    @JsonIgnore
    public String getColumnNameFromCaption() {
        String newColumnName = this.caption.toLowerCase().replaceAll("\\s+", "_").replaceAll("[^a-z0-9-]", "_");
        return newColumnName;
    }
}

