/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository;

import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.repository.dto.FactDto;
import de.superx.jdbc.repository.BiaAdminCrudRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.query.Param;

@RepositoryDefinition(domainClass=FactDto.class, idClass=Identifier.class)
public interface FactRepository
extends BiaAdminCrudRepository<FactDto> {
    public List<FactDto> findAll();

    public Optional<FactDto> findById(Identifier var1);

    public Optional<FactDto> findByTablename(String var1);

    @Query(value="SELECT COUNT(*) > 0  FROM metadata.facttable f  LEFT JOIN metadata.measure m    ON m.facttable_id = f.id WHERE f.id = :factId   AND m.id = :measureId")
    public boolean hasFactTableMeasure(@Param(value="factId") String var1, @Param(value="measureId") String var2);

    @Query(value="SELECT f.tablename  FROM metadata.dimension_attribute da  LEFT JOIN metadata.dimension d    ON d.id = da.dimension_id  LEFT JOIN metadata.facttable f    ON f.id = d.facttable_id WHERE f.id = :factId   AND (da.conformed = :attrId OR da.id = :attrId)")
    public String getFactTableNameForAttribute(@Param(value="factId") String var1, @Param(value="attrId") String var2);
}

