/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.repository;

import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.repository.dto.AttributeDto;
import de.superx.jdbc.repository.BiaAdminCrudRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.query.Param;

@RepositoryDefinition(domainClass=AttributeDto.class, idClass=Identifier.class)
public interface DimensionAttributeRepository
extends BiaAdminCrudRepository<AttributeDto> {
    public List<AttributeDto> findByDimensionId(Identifier var1);

    public Optional<AttributeDto> findById(Identifier var1);

    default public AttributeDto findByIdOrThrow(Identifier id) {
        return this.findById(id).orElseThrow(() -> new FaultyMetadataException(id));
    }

    @Query(value="SELECT da.id FROM metadata.dimension_attribute da LEFT JOIN metadata.dimension d   ON d.id = da.dimension_id WHERE da.conformed = :confAttrId   AND facttable_id = :factId")
    public List<Identifier> findAttributesByConformedAttributeAndFactTable(@Param(value="confAttrId") String var1, @Param(value="factId") String var2);

    @Query(value="SELECT da.id  FROM metadata.dimension_attribute da  LEFT JOIN metadata.dimension d    ON d.id = da.dimension_id WHERE da.id = :attrId   AND d.facttable_id = :factId")
    public Identifier findAttributesByIdAndFactTable(@Param(value="attrId") String var1, @Param(value="factId") String var2);

    @Query(value="SELECT * FROM metadata.dimension_attribute WHERE criteria_groups IS NOT NULL")
    public List<AttributeDto> findByNonEmptyCriteriaGroup();

    public Optional<AttributeDto> findByDimensionIdAndAttrConformedId(Identifier var1, String var2);
}

