/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.bin;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.superx.bianalysis.bin.ColumnCollector;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.metadata.MetaImport;
import de.superx.bianalysis.metadata.MetaImportConformedDimensions;
import de.superx.bianalysis.metadata.MetaJson;
import de.superx.bianalysis.metadata.MetadataImporter;
import de.superx.bianalysis.metadata.models.json.MetaDimension;
import de.superx.bianalysis.metadata.models.json.MetaDimensionAttribute;
import de.superx.bianalysis.metadata.models.json.MetaFact;
import de.superx.bianalysis.metadata.models.json.MetaMeasure;
import de.superx.bianalysis.metadata.models.json.MetaObject;
import de.superx.bianalysis.metadata.models.yml.MetaYml;
import de.superx.bianalysis.metadata.models.yml.MetaYmlModel;
import de.superx.bianalysis.metadata.models.yml.MetaYmlModelColumns;
import de.superx.dbt.DbtUtils;
import de.superx.etl.biad.SourceTable;
import de.superx.etl.biad.SourcesYML;
import de.superx.servlet.SuperXManager;
import de.superx.util.PathAndFileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BiAnalysisCLI {
    private static final String DEFAULT_RELEASE_BRANCH = "2026_06";

    public static void main(String[] args) throws IOException {
        Options options = BiAnalysisCLI.createOptions();
        CommandLine parsedArgs = BiAnalysisCLI.readArgs(args, options);
        if (parsedArgs.hasOption("-i")) {
            BiAnalysisCLI.addMissingIdsInMetadataDir(parsedArgs);
        } else if (parsedArgs.hasOption("-m")) {
            BiAnalysisCLI.convertJsonFilesToSql();
        } else if (parsedArgs.hasOption("-y")) {
            BiAnalysisCLI.generateYmlForJsonFile(parsedArgs);
        } else if (parsedArgs.hasOption("-d")) {
            BiAnalysisCLI.generateWikiMarkdown(parsedArgs);
        } else if (parsedArgs.hasOption("-s")) {
            BiAnalysisCLI.validateMetadataAgainstSchema();
        } else if (parsedArgs.hasOption("-k")) {
            BiAnalysisCLI.updateSourcesYml();
        } else {
            BiAnalysisCLI.printHelp(options);
        }
    }

    private static void updateSourcesYml() throws IOException {
        SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
        File ymlFile = new File(PathAndFileUtils.getSourcesYMLinSrcDbt());
        File modelsDir = new File(PathAndFileUtils.getDbtCompiledModelsCoreDirectory());
        List<String> files = PathAndFileUtils.findSqlFiles(modelsDir);
        if (files.isEmpty()) {
            throw new RuntimeException("[ERROR] - No SQL Files found in " + modelsDir.getAbsolutePath());
        }
        HashMap allUniqueCols = new HashMap();
        for (String string : files) {
            File file = new File(string);
            String sql = Files.readString(Paths.get(string, new String[0]));
            if (!sql.contains("staging")) {
                System.out.println("[INFO] - Skipping file: " + file.getName());
                continue;
            }
            System.out.println("[INFO] - Searching file: " + file.getName());
            ColumnCollector columnCollector = new ColumnCollector(string);
            columnCollector.parseForFile();
            Map<String, List<String>> cols = columnCollector.getColumns();
            for (String string2 : cols.keySet()) {
                if (!allUniqueCols.containsKey(string2)) {
                    allUniqueCols.put(string2, new ArrayList());
                }
                for (String column : cols.get(string2)) {
                    if (((List)allUniqueCols.get(string2)).contains(column)) continue;
                    ((List)allUniqueCols.get(string2)).add(column);
                }
            }
        }
        ArrayList<SourceTable> referencedTables = new ArrayList<SourceTable>();
        for (String table : allUniqueCols.keySet()) {
            if (!table.startsWith("\"staging\"")) continue;
            String cleaned = table.replace("\"", "");
            String[] stringArray = cleaned.split("\\.");
            String tableName = stringArray[stringArray.length - 1];
            SourceTable source = new SourceTable(tableName, (List)allUniqueCols.get(table));
            referencedTables.add(source);
        }
        SourcesYML sourcesYML = SourcesYML.fromJson(ymlFile);
        List<SourceTable> ymlSourceTablesStaging = sourcesYML.getSources().get(0).getTables();
        for (SourceTable sourceTable : ymlSourceTablesStaging) {
            if (sourceTable.isManual() != null && sourceTable.isManual().booleanValue()) {
                System.out.println(String.format("[INFO] - SKIPPING manual Table %s ", sourceTable.getName()));
                continue;
            }
            if (BiAnalysisCLI.isSourceTablePresent(sourceTable.getName(), referencedTables)) {
                if (BiAnalysisCLI.isNullOrEmpty(sourceTable.getExtractionInclude())) {
                    List<String> columns = BiAnalysisCLI.findExtractionInclude(sourceTable.getName(), referencedTables);
                    sourceTable.setExtractionInclude(columns);
                    continue;
                }
                ArrayList<String> colsToRemove = new ArrayList<String>();
                for (String string : sourceTable.getExtractionInclude()) {
                    if (BiAnalysisCLI.isColumnPresentInTable(string, sourceTable.getName(), referencedTables)) continue;
                    colsToRemove.add(string);
                    System.out.println(String.format("[WARNING] - Remove unused Column '%s' for Table '%s'", string, sourceTable.getName()));
                }
                sourceTable.getExtractionInclude().removeAll(colsToRemove);
                ArrayList<String> colsToAdd = new ArrayList<String>();
                for (String column3 : BiAnalysisCLI.getColumnsOfTable(sourceTable.getName(), referencedTables)) {
                    if (sourceTable.getExtractionInclude().contains(column3)) continue;
                    colsToAdd.add(column3);
                    System.out.println(String.format("[INFO] - Found new Column %s for Table : %s", column3, sourceTable.getName()));
                }
                sourceTable.getExtractionInclude().addAll(colsToAdd);
                continue;
            }
            System.out.println("[WARNING] - possibly unused table '" + sourceTable.getName() + "'");
        }
        List seeds = Files.list(PathAndFileUtils.getDbtSeedDir()).map(p -> p.getFileName().toString()).map(name -> {
            int dotIndex = name.lastIndexOf(46);
            return dotIndex > 0 ? name.substring(0, dotIndex) : name;
        }).collect(Collectors.toList());
        for (SourceTable sourceTable : referencedTables) {
            if (seeds.contains(sourceTable.getName()) || BiAnalysisCLI.isSourceTablePresent(sourceTable.getName(), ymlSourceTablesStaging)) continue;
            System.out.println("[INFO] - Add new table " + sourceTable.getName());
            ymlSourceTablesStaging.add(sourceTable);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        DefaultIndenter indenter = new DefaultIndenter("    ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            objectMapper.writer((PrettyPrinter)printer).writeValue(ymlFile, (Object)sourcesYML);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static CompletableFuture<String> readOutStream(InputStream is) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStreamReader isr = new InputStreamReader(is);){
                String string;
                try (BufferedReader br = new BufferedReader(isr);){
                    String inputLine;
                    StringBuilder res = new StringBuilder();
                    while ((inputLine = br.readLine()) != null) {
                        res.append(inputLine).append(System.lineSeparator());
                    }
                    string = res.toString();
                }
                return string;
            }
            catch (Throwable e) {
                throw new RuntimeException("problem with executing program", e);
            }
        });
    }

    private static int runValidationProcess(List<String> command, Path workingDir, String validationMessage) throws IOException, InterruptedException, ExecutionException {
        ProcessBuilder builder = new ProcessBuilder(command).directory(workingDir.toFile());
        Process process = builder.start();
        CompletableFuture<String> outputFuture = BiAnalysisCLI.readOutStream(process.getInputStream());
        CompletableFuture<String> errorFuture = BiAnalysisCLI.readOutStream(process.getErrorStream());
        int exitCode = process.waitFor();
        String output = outputFuture.get();
        String error = errorFuture.get();
        System.out.println(validationMessage);
        if (!output.isEmpty()) {
            System.out.print(output);
        }
        if (!error.isEmpty()) {
            System.err.print(error);
        }
        return exitCode;
    }

    private static void validateMetadataAgainstSchema() {
        SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
        Path metadataFolder = DbtUtils.getBiAnalysisMetadataFolder();
        File directory = metadataFolder.toFile();
        File[] files = directory.listFiles();
        if (files == null) {
            System.err.println("Failed to list files in directory: " + metadataFolder.toString());
            return;
        }
        ArrayList<String> metaimportFiles = new ArrayList<String>();
        ArrayList<String> conformedMetaimportFiles = new ArrayList<String>();
        for (File file : files) {
            String name = file.getName();
            if (!name.endsWith("_metaimport.json")) continue;
            if (name.endsWith("_conformed_dimensions_metaimport.json")) {
                conformedMetaimportFiles.add(file.getName());
                continue;
            }
            metaimportFiles.add(file.getName());
        }
        List<String> baseCommand = List.of(DbtUtils.getPython3ExecutableName(), DbtUtils.getDbtBinaryInBinaryFolder("jsonschema").toString(), "--output", "pretty");
        ArrayList<String> commandConformed = new ArrayList<String>(baseCommand);
        for (String string : conformedMetaimportFiles) {
            commandConformed.add("--instance");
            commandConformed.add(string);
        }
        commandConformed.add(metadataFolder.resolve("schema/metaimport_conformed_schema.json").toString());
        ArrayList<String> commandNotConformed = new ArrayList<String>(baseCommand);
        for (String file : metaimportFiles) {
            commandNotConformed.add("--instance");
            commandNotConformed.add(file);
        }
        commandNotConformed.add(metadataFolder.resolve("schema/metaimport_schema.json").toString());
        try {
            int n = BiAnalysisCLI.runValidationProcess(commandConformed, metadataFolder, "===[VALIDATING]=== *_conformed_dimensions_metaimport.json files against schema:");
            if (n != 0) {
                System.exit(n);
            }
            int notConformedExitCode = BiAnalysisCLI.runValidationProcess(commandNotConformed, metadataFolder, "===[VALIDATING]=== *_metaimport.json files against schema:");
            System.exit(notConformedExitCode);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error processing validation output", exception);
        }
    }

    private static void generateWikiMarkdown(CommandLine parsedArgs) throws IOException {
        SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
        String facttable = parsedArgs.getOptionValue("d");
        String filePath = PathAndFileUtils.getReportGeneratorDir("hisinone");
        String ymlPath = PathAndFileUtils.getDbtModelsDirectory("hisinone") + File.separator + "docs_and_tests";
        MetadataImporter importer = new MetadataImporter(ymlPath);
        Logger.getLogger(MetadataImporter.class).setLevel(Level.ERROR);
        importer.deserializeMetadataFromJsonFiles(filePath);
        String docDirectory = PathAndFileUtils.getModulePath("biad");
        docDirectory = String.join((CharSequence)File.separator, docDirectory, "conf", "his1", "edustore_doc");
        for (MetaFact fact : importer.getAllFactTables()) {
            if (!"all".equals(facttable) && !fact.getFacttable().equals(facttable)) continue;
            String filepath = docDirectory + File.separator + fact.getFacttable() + "_mediawiki.txt";
            PrintWriter writer = new PrintWriter(filepath, "UTF-8");
            writer.println("== " + fact.getCaption() + " ==");
            writer.println("Tabelle: " + fact.getFacttable());
            writer.println(";" + fact.getCaption());
            writer.println(":" + fact.getDescription());
            writer.println();
            writer.println("===Kennzahlen ===");
            writer.println(";Kennzahlen " + fact.getCaption());
            writer.println();
            writer.println("{| class=\"wikitable\"\n ! Kennzahl !! Beschreibung");
            writer.println("|-");
            for (int i = 0; i < fact.getMeasures().size(); ++i) {
                MetaMeasure m = fact.getMeasures().get(i);
                writer.println("| " + m.getCaption());
                writer.println("| " + m.getDescription());
                if (i == fact.getMeasures().size() - 1) continue;
                writer.println("|-");
            }
            writer.println("|-\n|}");
            writer.println();
            writer.println();
            writer.println("===Dimension ===");
            writer.println(";" + fact.getCaption());
            writer.println(":" + fact.getDescription());
            writer.println();
            writer.println("'''Dimension und  Dimensionsattribut'''");
            writer.println();
            for (MetaDimension d : fact.getDimensions()) {
                String dimDescription;
                String dimCaption = d.getCaption();
                if ((dimCaption == null || dimCaption.isBlank()) && d.getConformedDimension() != null) {
                    dimCaption = d.getConformedDimension().getCaption();
                }
                if (((dimDescription = d.getDescription()) == null || dimDescription.isBlank()) && d.getConformedDimension() != null) {
                    dimDescription = d.getConformedDimension().getDescription();
                }
                writer.println(";" + dimCaption);
                writer.println(":" + dimDescription);
                List<MetaDimensionAttribute> attributes = d.getAttributes();
                if ((attributes == null || attributes.size() == 0) && d.getConformedDimension() != null) {
                    attributes = d.getConformedDimension().getAttributes();
                }
                for (MetaDimensionAttribute a : attributes) {
                    String caption = a.getCaption() == null ? a.getConfDimAttrRef().getCaption() : a.getCaption();
                    writer.println("*" + caption);
                    try {
                        String desc = a.getDescription() == null ? a.getConfDimAttrRef().getDescription() : a.getDescription();
                        if (desc.equals("null")) continue;
                        writer.println("*:" + desc);
                    }
                    catch (Exception exception) {}
                }
                writer.println();
            }
            writer.close();
            System.out.println("Written to file " + filepath);
        }
    }

    private static void generateYmlForJsonFile(CommandLine parsedArgs) {
        String[] dirs = parsedArgs.getOptionValues("c");
        String filename = parsedArgs.getOptionValue("y");
        if (!parsedArgs.hasOption("c") || dirs == null || dirs.length == 0) {
            throw new RuntimeException("The 'dirs' option (-c) is required and must have at least one argument.");
        }
        for (String dirPath : dirs) {
            if (dirPath != null && new File(dirPath).exists()) continue;
            throw new RuntimeException("Directory (or file) " + dirPath + " is not valid.");
        }
        if (filename == null || filename.isBlank() || !filename.endsWith("_metaimport.json")) {
            throw new RuntimeException("Filename is not valid.");
        }
        MetadataImporter importer = new MetadataImporter();
        Logger.getLogger(MetadataImporter.class).setLevel(Level.ERROR);
        importer.setShouldReadYMLDoc(false);
        importer.deserializeMetadataFromJsonFiles(dirs);
        MetaImport meta = importer.getMetaImport(filename).orElseThrow(() -> new RuntimeException("File " + filename + " is not valid."));
        MetaYml yml = BiAnalysisCLI.createYMLFileForMetaJson(meta);
        File file = importer.getMetaJson(filename).get().getFile();
        Path dir = Path.of("src-dbt", "hisinone", "transform", "models", "docs_and_tests");
        String ymlFileName = filename.split("_metaimport.json")[0] + ".yml";
        String srcDir = "";
        srcDir = file.getAbsolutePath().contains("cs.bia.his.components") ? "cs.bia.his.components" : "superx";
        Path path = Path.of(PathAndFileUtils.getPathUpToDir(file.getAbsolutePath(), srcDir), new String[0]);
        path = path.resolve(dir);
        path = path.resolve(ymlFileName);
        System.out.println("Written to yml file: ");
        System.out.println(path);
        MetadataImporter.writeYmlToFile(yml, new File(path.toString()));
    }

    private static List<Object> getTests(String to, String field) {
        ArrayList<Object> tests = new ArrayList<Object>();
        tests.add("not_null");
        tests.add(Map.of("relationships", Map.of("to", "ref('" + to + "')", "field", field)));
        return tests;
    }

    private static MetaYml createYMLFileForMetaJson(MetaJson metaJson) {
        MetaYml newYml = new MetaYml();
        ArrayList<MetaYmlModel> newYmlModels = new ArrayList<MetaYmlModel>();
        newYml.setVersion(1);
        newYml.setModels(newYmlModels);
        if (metaJson instanceof MetaImport) {
            MetaImport metaimport = (MetaImport)metaJson;
            for (MetaFact fact : metaimport.facts) {
                MetaYmlModel factModel = new MetaYmlModel(fact.getFacttable(), " ", "unique_rows");
                newYmlModels.add(factModel);
                ArrayList<MetaYmlModelColumns> factCols = new ArrayList<MetaYmlModelColumns>();
                for (MetaDimension dim : fact.getDimensions()) {
                    String factCol;
                    String dimColumn;
                    String string = dimColumn = dim.getIdColumn() == null ? "id" : dim.getIdColumn();
                    if (dim.getRefTo() == null) {
                        factCols.add(new MetaYmlModelColumns(dim.getFactColumn(), " ", BiAnalysisCLI.getTests(dim.getDimension(), dimColumn)));
                        MetaYmlModel dimModel = new MetaYmlModel(dim.getDimension(), " ");
                        newYmlModels.add(dimModel);
                        ArrayList<MetaYmlModelColumns> dimCols = new ArrayList<MetaYmlModelColumns>();
                        for (MetaDimensionAttribute attr : dim.getAttributes()) {
                            dimCols.add(new MetaYmlModelColumns(attr.getDimColumn(), " ", "not_null"));
                        }
                        dimModel.setColumns(dimCols);
                        continue;
                    }
                    MetaDimension refToDim = dim.getConformedDimension();
                    String toCol = dim.getFactColumn();
                    if (toCol == null || toCol.isBlank()) {
                        toCol = dim.getRefTo();
                    }
                    if ((factCol = dim.getFactColumn()) == null || factCol.isBlank()) {
                        factCol = refToDim.getFactColumn();
                    }
                    factCols.add(new MetaYmlModelColumns(factCol, " ", BiAnalysisCLI.getTests(dim.getRefTo(), dimColumn)));
                }
                factModel.setColumns(factCols);
            }
        } else {
            MetaImportConformedDimensions metaimport = (MetaImportConformedDimensions)metaJson;
            for (MetaDimension dim : metaimport.conformedDimensions) {
                MetaYmlModel dimModel = new MetaYmlModel(dim.getDimension(), " ");
                newYmlModels.add(dimModel);
                ArrayList<MetaYmlModelColumns> dimCols = new ArrayList<MetaYmlModelColumns>();
                for (MetaDimensionAttribute attr : dim.getAttributes()) {
                    dimCols.add(new MetaYmlModelColumns(attr.getDimColumn(), " ", "not_null"));
                }
                dimModel.setColumns(dimCols);
            }
        }
        return newYml;
    }

    private static void addMissingIdsInMetadataDir(CommandLine parsedArgs) {
        String[] files = parsedArgs.getOptionValues("i");
        BasicConfigurator.configure();
        try {
            MetadataImporter metaImporter = new MetadataImporter();
            metaImporter.setShouldReadYMLDoc(false);
            metaImporter.deserializeMetadataFromJsonFiles(files);
            for (MetaJson meta : metaImporter.getMetaJsons()) {
                List<Identifier> allIds = meta.getIds();
                boolean isFileUpdateNecessary = false;
                for (MetaObject obj : meta.getMetaObjects()) {
                    if (obj.getId() == null && obj.getNamespace() != null) {
                        Identifier id = Identifier.getNewIdentifierValue(allIds, obj.getNamespace());
                        obj.setId(id);
                        allIds.add(id);
                        isFileUpdateNecessary = true;
                    }
                    if (obj.getDefaultRelease() != null) continue;
                    obj.setDefaultRelease(DEFAULT_RELEASE_BRANCH);
                    isFileUpdateNecessary = true;
                }
                if (!isFileUpdateNecessary) continue;
                BiAnalysisCLI.writeMetaImportToFile(meta);
                Logger.getRootLogger().info((Object)("Updated file " + meta.getFile().getPath()));
            }
            if (!metaImporter.errorMessages.isEmpty()) {
                System.out.println(metaImporter.getPrintableErrorMessages());
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void convertJsonFilesToSql() {
        SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
        String filePath = PathAndFileUtils.getReportGeneratorDir("hisinone");
        String ymlPath = PathAndFileUtils.getDbtModelsDirectory("hisinone");
        Object out = "DROP TABLE IF EXISTS metadata.facttable; DROP TABLE IF EXISTS metadata.measure; DROP TABLE IF EXISTS metadata.measure_filter; DROP TABLE IF EXISTS metadata.dimension; DROP TABLE IF EXISTS metadata.dimension_attribute; ";
        Path schemaSqlDir = Path.of("superx", "WEB-INF", "conf", "edustore", "db", "install", "schluesseltabellen");
        out = (String)out + BiAnalysisCLI.readLinesWithNewline(new File(schemaSqlDir.toString() + File.separator + "biad_create_meta_tables.sql"));
        out = (String)out + BiAnalysisCLI.readLinesWithNewline(new File(schemaSqlDir.toString() + File.separator + "biad_alter_meta_tables.sql"));
        out = (String)out + BiAnalysisCLI.readLinesWithNewline(new File(schemaSqlDir.toString() + File.separator + "biad_metadaten_fuellen.sql"));
        Logger.getLogger(MetadataImporter.class).setLevel(Level.ERROR);
        MetadataImporter importer = new MetadataImporter(ymlPath);
        importer.deserializeMetadataFromJsonFiles(filePath);
        out = (String)out + String.join((CharSequence)"\n", importer.getAllUpsertStrings(false));
        if (!importer.errorMessages.isEmpty()) {
            System.out.println(importer.getPrintableErrorMessages());
            System.exit(1);
        } else {
            System.out.println((String)out);
        }
    }

    private static CommandLine readArgs(String[] args, Options options) {
        GnuParser parser = new GnuParser();
        try {
            return parser.parse(options, args, false);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.setOptionComparator(null);
        help.setWidth(200);
        help.printHelp("This tool streamlines common tasks during development for the BIAnalysis.", options);
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"convert metadata directory to sql");
        OptionBuilder.withLongOpt((String)"convert-metadata");
        Option outMeta = OptionBuilder.create((String)"m");
        OptionBuilder.withDescription((String)"validate metadata json files against schema");
        OptionBuilder.withLongOpt((String)"validate-metadata-schema");
        Option validate = OptionBuilder.create((String)"s");
        OptionBuilder.withDescription((String)"generate yml documentation for json file");
        OptionBuilder.withLongOpt((String)"generate-yml");
        OptionBuilder.withArgName((String)"json-file");
        OptionBuilder.hasArg((boolean)true);
        Option generateYml = OptionBuilder.create((String)"y");
        OptionBuilder.withDescription((String)"json directories (use ONLY in combination with -y)");
        OptionBuilder.withArgName((String)"create-from-dirs");
        OptionBuilder.hasArgs();
        Option jsonDir = OptionBuilder.create((String)"c");
        OptionBuilder.withDescription((String)"update sources yml from compiled models directory");
        OptionBuilder.withLongOpt((String)"update-sources-yml");
        Option sourcesYml = OptionBuilder.create((String)"k");
        OptionBuilder.withDescription((String)"generate wiki documentation for measures and dimensions");
        OptionBuilder.withLongOpt((String)"generate-doc");
        OptionBuilder.withArgName((String)"facttable");
        OptionBuilder.hasArg((boolean)true);
        Option generateDoc = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"add-ids");
        OptionBuilder.withDescription((String)"add missing ids to json files");
        OptionBuilder.withArgName((String)"directories");
        OptionBuilder.hasArgs();
        Option updateIds = OptionBuilder.create((String)"i");
        options.addOption(validate);
        options.addOption(sourcesYml);
        options.addOption(updateIds);
        options.addOption(generateYml);
        options.addOption(jsonDir);
        options.addOption(generateDoc);
        options.addOption(outMeta);
        options.addOption(new Option("h", "help", false, "get help"));
        return options;
    }

    public static void writeMetaImportToFile(MetaJson meta) {
        ObjectMapper mapper = new ObjectMapper();
        DefaultIndenter indenter = new DefaultIndenter("    ", DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        try {
            mapper.writer((PrettyPrinter)printer).writeValue(meta.getFile(), (Object)meta);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String readLinesWithNewline(File file) {
        Object result = "";
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                result = (String)result + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (String)result + "\n";
    }

    private static List<String> getColumnsOfTable(String name, List<SourceTable> sourceTables) {
        for (SourceTable sourceTable : sourceTables) {
            if (!sourceTable.getName().equals(name)) continue;
            return sourceTable.getExtractionInclude();
        }
        return null;
    }

    private static boolean isColumnPresentInTable(String column, String name, List<SourceTable> sourceTables) {
        for (SourceTable sourceTable : sourceTables) {
            if (!sourceTable.getName().equals(name)) continue;
            for (String col : sourceTable.getExtractionInclude()) {
                if (!col.equals(column)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> findExtractionInclude(String name, List<SourceTable> sourceTables) {
        for (SourceTable sourceTable : sourceTables) {
            if (!sourceTable.getName().equals(name)) continue;
            return sourceTable.getExtractionInclude();
        }
        return null;
    }

    private static boolean isSourceTablePresent(String name, List<SourceTable> sourceTables) {
        for (SourceTable sourceTable : sourceTables) {
            if (!sourceTable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

