/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.service.DbMetaAdapter;
import java.util.ArrayList;
import java.util.List;

public class ReportDefinition {
    public List<Identifier> factTableIds;
    public List<Identifier> leftDimensionAttributeIds;
    public List<Identifier> topDimensionAttributeIds;
    public List<Identifier> measureIds;
    public List<Filter> filters;
    public boolean hideEmptyColumns;

    public ReportDefinition() {
        this.factTableIds = new ArrayList<Identifier>();
        this.leftDimensionAttributeIds = new ArrayList<Identifier>();
        this.topDimensionAttributeIds = new ArrayList<Identifier>();
        this.measureIds = new ArrayList<Identifier>();
        this.filters = new ArrayList<Filter>();
        this.hideEmptyColumns = false;
    }

    public ReportDefinition(ReportDefinition definition) {
        this.factTableIds = definition.factTableIds;
        this.topDimensionAttributeIds = definition.topDimensionAttributeIds;
        this.measureIds = definition.measureIds;
        this.filters = definition.filters;
        this.leftDimensionAttributeIds = new ArrayList<Identifier>();
        this.hideEmptyColumns = definition.hideEmptyColumns;
    }

    public ReportMetadata getReportMetadata(DbMetaAdapter dbAdapter, Identifier factTableId) {
        ReportMetadata reportMetadata = new ReportMetadata(this, factTableId, dbAdapter);
        return reportMetadata;
    }

    public static List<Identifier> getAttributesForDefinitions(List<ReportDefinition> definitions) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        for (ReportDefinition def : definitions) {
            for (Identifier id : def.topDimensionAttributeIds) {
                ids.add(id);
            }
            for (Identifier id : def.leftDimensionAttributeIds) {
                ids.add(id);
            }
        }
        return ids;
    }
}

