/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.ColumnElement;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.Measure;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.log4j.Logger;

public class ColumnElementBuilder {
    private static Logger logger = Logger.getLogger(ColumnElementBuilder.class);

    public static List<ColumnElement> buildColumnElements(ReportMetadata metadata) {
        List<Filter> filters = metadata.filters;
        List<Measure> measures = metadata.measures;
        List<DimensionAttribute> dimensionAttributes = metadata.topDimensionAttributes;
        ArrayList<ColumnElement> columnElements = new ArrayList<ColumnElement>();
        String HEADER_DIVIDER = " || ";
        String KENNZAHL_IDENTIFIER = "Kennzahl|";
        if (measures == null || measures.isEmpty()) {
            return columnElements;
        }
        int colStartPoint = metadata.getHierarchyAttributes().size() * metadata.maxBridgeLvl;
        if (dimensionAttributes == null || dimensionAttributes.isEmpty()) {
            for (Measure measure : measures) {
                columnElements.add(new ColumnElement(measure, colStartPoint + columnElements.size()));
            }
            return columnElements;
        }
        List<List<String>> dimAttrCombinations = ColumnElementBuilder.cartesianProductOfDimensionAttributeValues(dimensionAttributes, filters);
        for (int i = 0; i < dimAttrCombinations.size(); ++i) {
            StringJoiner captionJoiner = new StringJoiner(" || ");
            StringJoiner headerJoiner = new StringJoiner(" || ");
            StringJoiner filterJoiner = new StringJoiner(" AND ");
            List<String> comb = dimAttrCombinations.get(i);
            for (int j = 0; j < comb.size(); ++j) {
                DimensionAttribute attr = dimensionAttributes.get(j);
                String value = comb.get(j);
                captionJoiner.add(ColumnElement.buildField(attr, value));
                headerJoiner.add(ColumnElement.buildHeader(attr, value));
                filterJoiner.add(ColumnElement.buildFilter(attr, value));
            }
            String partialCaption = captionJoiner.toString();
            String partialHeader = headerJoiner.toString();
            String filter = filterJoiner.toString();
            for (Measure measure : measures) {
                String finalCaption = partialCaption + " || Kennzahl|" + measure.getId().composedId;
                String finalHeader = partialHeader + " || Kennzahl|" + measure.getCaption();
                ColumnElement colElement = new ColumnElement(finalCaption, filter, measure, colStartPoint + columnElements.size());
                colElement.setHeader(finalHeader);
                columnElements.add(colElement);
            }
        }
        return columnElements;
    }

    private static List<List<String>> cartesianProductOfDimensionAttributeValues(List<DimensionAttribute> dimensionAttributes, List<Filter> filters) {
        ArrayList<List<String>> allDimAttrVals = new ArrayList<List<String>>();
        for (DimensionAttribute attr : dimensionAttributes) {
            Filter compoundFilter = Filter.findFilterById(filters, attr.getId());
            if (compoundFilter != null) {
                allDimAttrVals.add(compoundFilter.filterValues);
                continue;
            }
            allDimAttrVals.add(attr.getDimensionAttributeValues());
        }
        return ColumnElementBuilder.cartesian(allDimAttrVals);
    }

    private static List<List<String>> cartesian(List<List<String>> lists) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (lists.size() == 0) {
            result.add(new ArrayList());
            return result;
        }
        List<String> curr = lists.get(0);
        List<List<String>> remainingLists = ColumnElementBuilder.cartesian(lists.subList(1, lists.size()));
        for (String val : curr) {
            for (List<String> list : remainingLists) {
                ArrayList<String> resultList = new ArrayList<String>();
                resultList.add(val);
                resultList.addAll(list);
                result.add(resultList);
            }
        }
        return result;
    }
}

