/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.DateTimeFormatter;
import de.memtext.util.FileUtils;
import de.memtext.util.RawFormatter;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

public class LogUtils {
    private static ConsoleAppender rawConsoleHandler = new ConsoleAppender();

    private LogUtils() {
    }

    public static void initRaw(String loggername) {
        LogUtils.initRaw(Logger.getLogger((String)loggername));
    }

    public static void initRaw(Logger logger) {
        logger.addAppender((Appender)rawConsoleHandler);
        logger.setAdditivity(false);
        logger.setLevel(Level.WARN);
    }

    public static void initRawFile(String loggername, String filename, int maxKB, int count, boolean append, boolean tryLckDeletion) throws SecurityException, IOException {
        if (tryLckDeletion) {
            if (count > 1) {
                throw new IllegalArgumentException("tryLckDeletion doesn't work for >1 file");
            }
            File f = new File(filename + ".lck");
            if (f.exists()) {
                f.delete();
            }
        }
        if (count > 1) {
            filename = FileUtils.addToEndOfFileName(filename, "%g");
        }
        RollingFileAppender fh = new RollingFileAppender((Layout)new RawFormatter(), filename, append);
        fh.setThreshold((Priority)Level.ALL);
        fh.activateOptions();
        String maxFileSize = Integer.toString(maxKB) + "KB";
        fh.setMaxFileSize(maxFileSize);
        fh.setMaxBackupIndex(count);
        Logger.getLogger((String)loggername).addAppender((Appender)fh);
    }

    public static void initRawFileDateTime(String loggername, String filename, int maxKB, int count, boolean append, boolean tryLckDeletion) throws SecurityException, IOException {
        if (tryLckDeletion) {
            if (count > 1) {
                throw new IllegalArgumentException("tryLckDeletion doesn't work for >1 file");
            }
            File f = new File(filename + ".lck");
            if (f.exists()) {
                f.delete();
            }
        }
        if (count > 1) {
            filename = FileUtils.addToEndOfFileName(filename, "%g");
        }
        RollingFileAppender fh = new RollingFileAppender((Layout)new DateTimeFormatter(), filename, append);
        String maxFileSize = Integer.toString(maxKB) + "KB";
        fh.setMaxFileSize(maxFileSize);
        fh.setMaxBackupIndex(count);
        Logger.getLogger((String)loggername).addAppender((Appender)fh);
        Logger.getLogger((String)loggername).setAdditivity(false);
    }

    public static void close(String loggername) {
        Enumeration appenders = Logger.getLogger((String)loggername).getAllAppenders();
        Iterator it = appenders.asIterator();
        while (it.hasNext()) {
            ((Appender)it.next()).close();
        }
    }

    public static void main(String[] args) {
        try {
            LogUtils.initRawFile("superx_10000", "d:\\temp\\superx_10000.log", 2000, 1, true, true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.getLogger((String)"superx_10000").log((Priority)Level.ERROR, (Object)"sql: \u00f6alskjf");
    }

    static {
        RawFormatter rf = new RawFormatter();
        rf.setTimeWanted(true);
        rawConsoleHandler.setLayout((Layout)rf);
    }
}

