/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.TimeUtils;
import de.superx.common.Maske;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(Maske.class);
    protected static DateFormat df = new SimpleDateFormat("dd.MM.yy");
    protected static DateFormat dfLong = new SimpleDateFormat("dd.MM.yyyy");
    protected static DateFormat dfUS = new SimpleDateFormat("yyyy-MM-dd");
    protected static DateFormat dfDateTimeUS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static DateFormat dfTime = new SimpleDateFormat("hh:mm:ss");
    protected static DateFormat dfDateTime = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    protected static DateFormat dfDay = new SimpleDateFormat("dd");
    protected static DateFormat dfMonth = new SimpleDateFormat("MM");
    protected static DateFormat dfYear = new SimpleDateFormat("yyyy");

    protected DateUtils() {
    }

    public static String getNowString() {
        return TimeUtils.getNowString();
    }

    public static String getDay(java.sql.Date date) {
        return dfDay.format(date);
    }

    public static String getMonth(java.sql.Date date) {
        return dfMonth.format(date);
    }

    public static String getYear(java.sql.Date date) {
        return dfYear.format(date);
    }

    public static String toCommaSeparatedList(java.sql.Date date) {
        return DateUtils.getDay(date) + "," + DateUtils.getMonth(date) + "," + DateUtils.getYear(date);
    }

    public static Date create(String datestr) {
        java.sql.Date d = null;
        try {
            d = DateUtils.parse(datestr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return d;
    }

    public static java.sql.Date parse(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            throw new ParseException("\"\" is unparseable", 0);
        }
        Date dt = df.parse(dateStr);
        return new java.sql.Date(dt.getTime());
    }

    public static java.sql.Date parseStrict(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            throw new ParseException("\"\" is unparseable", 0);
        }
        Date dt = dfLong.parse(dateStr);
        return new java.sql.Date(dt.getTime());
    }

    public static String format(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return dfLong.format(date);
    }

    public static boolean isToday(String dateStr) throws ParseException {
        java.sql.Date d = DateUtils.parse(dateStr);
        return DateUtils.format(d).equals(DateUtils.format(new Date()));
    }

    public static boolean isValidDate(String dateString) {
        boolean result = true;
        try {
            java.sql.Date d = DateUtils.parse(dateString);
            if (d.getYear() > 10000) {
                result = false;
            }
        }
        catch (ParseException e) {
            result = false;
        }
        return result;
    }

    public static boolean isDateInFuture(java.sql.Date date) {
        return date.getTime() > new Date().getTime();
    }

    public static boolean isDateInFuture(Date date) {
        return date.getTime() > new Date().getTime();
    }

    public static boolean isValidDateStrict(String dateString) {
        boolean result = true;
        try {
            java.sql.Date d = DateUtils.parseStrict(dateString);
            if (d.getYear() > 10000) {
                result = false;
            }
        }
        catch (ParseException e) {
            result = false;
        }
        return result;
    }

    public static String getTodayString() {
        return DateUtils.format(new java.sql.Date(new Date().getTime()));
    }

    public static void main(String[] a) {
    }

    public static String formatGerman(Date date) {
        return DateFormat.getDateInstance(2, Locale.GERMANY).format(date);
    }

    public static String formatUS(Date date) {
        if (date == null) {
            return null;
        }
        return dfUS.format(date);
    }

    public static Date dateTimeParse(String dateStr) throws ParseException {
        if (dateStr.equals("") || dateStr == null) {
            return null;
        }
        return dfDateTime.parse(dateStr);
    }

    public static String dateTimeFormat(Date date) {
        if (date == null) {
            return null;
        }
        return dfDateTime.format(date);
    }

    public static String dateTimeFormatUS(Date date) {
        if (date == null) {
            return null;
        }
        return dfDateTimeUS.format(date);
    }

    public static Date makeFutureDate(java.sql.Date date, int daysLater) {
        Calendar dateOnCalendar = Calendar.getInstance();
        dateOnCalendar.setTime(date);
        dateOnCalendar.add(5, daysLater);
        return dateOnCalendar.getTime();
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return dfLong.format(date);
    }

    public static boolean compareDates(String startDate, String endDate) throws Exception {
        if (!(startDate.contains(".") && endDate.contains(".") && startDate.substring(startDate.indexOf(".") + 1, startDate.length()).contains(".") && endDate.substring(endDate.indexOf(".") + 1, endDate.length()).contains("."))) {
            throw new Exception("Format der Daten ist nicht korrekt! (D(D).M(M).YYYY)");
        }
        String startDay = startDate.substring(0, startDate.indexOf("."));
        int startDayInt = DateUtils.parseInt(startDay, 0);
        String startMonth = startDate.substring(startDate.indexOf(".") + 1, startDate.length()).substring(0, startDate.indexOf("."));
        int startMonthInt = DateUtils.parseInt(startMonth, 0);
        String startYear = startDate.substring(startDate.lastIndexOf(".") + 1, startDate.length());
        int startYearInt = DateUtils.parseInt(startYear, 0);
        String endDay = endDate.substring(0, endDate.indexOf("."));
        int endDayInt = DateUtils.parseInt(endDay, 0);
        String endMonth = endDate.substring(endDate.indexOf(".") + 1, endDate.length()).substring(0, endDate.indexOf("."));
        int endMonthInt = DateUtils.parseInt(endMonth, 0);
        String endYear = endDate.substring(endDate.lastIndexOf(".") + 1, endDate.length());
        int endYearInt = DateUtils.parseInt(endYear, 0);
        if (startDayInt == 0 || startMonthInt == 0 || startYearInt < 100 || endDayInt == 0 || endMonthInt == 0 || endYearInt < 100) {
            logger.error("Format der Daten ist nicht korrekt, startDate='" + startDate + "'; endDate='" + endDate + "' ...");
            return false;
        }
        if (endYearInt > startYearInt) {
            return true;
        }
        if (endYearInt < startYearInt) {
            return false;
        }
        if (endMonthInt > startMonthInt) {
            return true;
        }
        if (endMonthInt < startMonthInt) {
            return false;
        }
        return endDayInt >= startDayInt;
    }

    public static int parseInt(String zahl, int defaultValue) {
        if (zahl == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(zahl);
        }
        catch (NumberFormatException e) {
            logger.warn("Ungueltige Zahl \"" + zahl + "\". Default-Wert " + defaultValue + " wird verwendet.");
            return defaultValue;
        }
    }

    static {
        df.setLenient(true);
        dfLong.setLenient(false);
    }
}

