/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.rights;

import de.memtext.rights.RightsKeyEntry;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.superx.common.OrgUnit;
import de.superx.common.OrgUnitMapping;
import de.superx.servlet.SxPools;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Rights
implements Serializable {
    private static final long serialVersionUID = 2L;
    private boolean isAdmin = false;
    private boolean hasAllRights;
    private Set<RightsKeyEntry> allowedRightKeyEntries = new TreeSet<RightsKeyEntry>();

    public Rights() {
    }

    public Rights(boolean isAdmin, boolean hasAllRights) {
        this.setAdmin(isAdmin);
        this.setHasAllRights(hasAllRights);
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void addAllowed(RightsKeyEntry rke) {
        this.allowedRightKeyEntries.add(rke);
    }

    public void clear() {
        this.isAdmin = false;
        this.hasAllRights = false;
        this.allowedRightKeyEntries.clear();
    }

    public boolean isEmpty() {
        return this.allowedRightKeyEntries.isEmpty();
    }

    public boolean hasNoRights() {
        return !this.isAdmin && !this.hasAllRights && this.isEmpty();
    }

    public boolean hasAllRights() {
        return this.hasAllRights;
    }

    public void setHasAllRights(boolean b) {
        this.hasAllRights = b;
    }

    public boolean isAllowed(Object id) {
        boolean result = false;
        if (this.isAdmin || this.hasAllRights()) {
            result = true;
        } else {
            for (RightsKeyEntry entry : this.allowedRightKeyEntries) {
                if (!EqualsUtil.areEqual(entry.getKey(), id)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isSubordinatesAllowed(Object key) {
        boolean result = false;
        if (this.isAdmin || this.hasAllRights()) {
            result = true;
        } else {
            for (RightsKeyEntry entry : this.allowedRightKeyEntries) {
                if (!EqualsUtil.areEqual(entry.getKey(), key)) continue;
                result = entry.isSubordinatesAllowed();
                break;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Rights cl = new Rights(this.isAdmin, this.hasAllRights);
        for (RightsKeyEntry key : this.allowedRightKeyEntries) {
            cl.allowedRightKeyEntries.add((RightsKeyEntry)key.clone());
        }
        return cl;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Rechte: ");
        for (RightsKeyEntry entry : this.allowedRightKeyEntries) {
            result.append(entry.toString() + ",");
        }
        StringUtils.removeLastChar(result);
        return result.toString();
    }

    public void add(Set<String> allowedKeys) {
        for (String aKey : allowedKeys) {
            this.allowedRightKeyEntries.add(new RightsKeyEntry(aKey, true));
        }
    }

    public void add(String allowedKey) {
        this.allowedRightKeyEntries.add(new RightsKeyEntry(allowedKey, true));
    }

    public void addOrgUnitRights(StringBuffer msg, Set<OrgUnit> orgUnits) {
        for (OrgUnit ou : orgUnits) {
            this.add(ou.getApnr());
            msg.append(ou.getApnr() + ",");
        }
    }

    public void addLiveMappingRights(StringBuffer msg, String mandantenID) {
        msg.append(" via LifeMapping :");
        TreeSet<String> lifeMappingApnrs = new TreeSet<String>();
        HashSet<String> keysBefore = new HashSet<String>();
        for (RightsKeyEntry re : this.allowedRightKeyEntries) {
            keysBefore.add((String)re.getKey());
            OrgUnitMapping oum = SxPools.get(mandantenID).getOrgUnitMappings().get(re.getKey().toString());
            if (oum == null) continue;
            lifeMappingApnrs.add(oum.getUniquename());
            for (String mappedId : oum.getMappedIds()) {
                lifeMappingApnrs.add(mappedId);
            }
        }
        lifeMappingApnrs.removeAll(keysBefore);
        for (String mappedId : lifeMappingApnrs) {
            this.add(mappedId);
            msg.append(mappedId + ",");
        }
    }

    public Set<String> getAllRightKeys() {
        TreeSet<String> keys = new TreeSet<String>();
        for (RightsKeyEntry re : this.allowedRightKeyEntries) {
            keys.add(re.getKey().toString());
        }
        return keys;
    }

    public Iterator<RightsKeyEntry> iterator() {
        return this.allowedRightKeyEntries.iterator();
    }
}

