/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.persistence.converter;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.persistence.ExecutionContext;
import org.springframework.batch.core.repository.persistence.ExitStatus;

public class StepExecutionConverter {
    public StepExecution toStepExecution(org.springframework.batch.core.repository.persistence.StepExecution source, JobExecution jobExecution) {
        StepExecution stepExecution = new StepExecution(source.getName(), jobExecution, source.getStepExecutionId());
        stepExecution.setStatus(source.getStatus());
        stepExecution.setReadCount(source.getReadCount());
        stepExecution.setWriteCount(source.getWriteCount());
        stepExecution.setCommitCount(source.getCommitCount());
        stepExecution.setRollbackCount(source.getRollbackCount());
        stepExecution.setReadSkipCount(source.getReadSkipCount());
        stepExecution.setProcessSkipCount(source.getProcessSkipCount());
        stepExecution.setWriteSkipCount(source.getWriteSkipCount());
        stepExecution.setFilterCount(source.getFilterCount());
        stepExecution.setStartTime(source.getStartTime());
        stepExecution.setCreateTime(source.getCreateTime());
        stepExecution.setEndTime(source.getEndTime());
        stepExecution.setLastUpdated(source.getLastUpdated());
        stepExecution.setExitStatus(new org.springframework.batch.core.ExitStatus(source.getExitStatus().exitCode(), source.getExitStatus().exitDescription()));
        stepExecution.setExecutionContext(new org.springframework.batch.item.ExecutionContext(source.getExecutionContext().map()));
        if (source.isTerminateOnly()) {
            stepExecution.setTerminateOnly();
        }
        return stepExecution;
    }

    public org.springframework.batch.core.repository.persistence.StepExecution fromStepExecution(StepExecution source) {
        org.springframework.batch.core.repository.persistence.StepExecution stepExecution = new org.springframework.batch.core.repository.persistence.StepExecution();
        stepExecution.setStepExecutionId(source.getId());
        stepExecution.setJobExecutionId(source.getJobExecutionId());
        stepExecution.setName(source.getStepName());
        stepExecution.setJobExecutionId(source.getJobExecutionId());
        stepExecution.setStatus(source.getStatus());
        stepExecution.setReadCount(source.getReadCount());
        stepExecution.setWriteCount(source.getWriteCount());
        stepExecution.setCommitCount(source.getCommitCount());
        stepExecution.setRollbackCount(source.getRollbackCount());
        stepExecution.setReadSkipCount(source.getReadSkipCount());
        stepExecution.setProcessSkipCount(source.getProcessSkipCount());
        stepExecution.setWriteSkipCount(source.getWriteSkipCount());
        stepExecution.setFilterCount(source.getFilterCount());
        stepExecution.setStartTime(source.getStartTime());
        stepExecution.setCreateTime(source.getCreateTime());
        stepExecution.setEndTime(source.getEndTime());
        stepExecution.setLastUpdated(source.getLastUpdated());
        stepExecution.setExitStatus(new ExitStatus(source.getExitStatus().getExitCode(), source.getExitStatus().getExitDescription()));
        org.springframework.batch.item.ExecutionContext executionContext = source.getExecutionContext();
        stepExecution.setExecutionContext(new ExecutionContext(executionContext.toMap(), executionContext.isDirty()));
        stepExecution.setTerminateOnly(source.isTerminateOnly());
        return stepExecution;
    }
}

