/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.util.Assert;

public class DefaultStepExecutionAggregator
implements StepExecutionAggregator {
    @Override
    public void aggregate(StepExecution result, Collection<StepExecution> executions) {
        Assert.notNull((Object)result, (String)"To aggregate into a result it must be non-null.");
        if (executions == null) {
            return;
        }
        for (StepExecution stepExecution : executions) {
            BatchStatus status = stepExecution.getStatus();
            result.setStatus(BatchStatus.max(result.getStatus(), status));
            result.setExitStatus(result.getExitStatus().and(stepExecution.getExitStatus()));
            result.setFilterCount(result.getFilterCount() + stepExecution.getFilterCount());
            result.setProcessSkipCount(result.getProcessSkipCount() + stepExecution.getProcessSkipCount());
            result.setCommitCount(result.getCommitCount() + stepExecution.getCommitCount());
            result.setRollbackCount(result.getRollbackCount() + stepExecution.getRollbackCount());
            result.setReadCount(result.getReadCount() + stepExecution.getReadCount());
            result.setReadSkipCount(result.getReadSkipCount() + stepExecution.getReadSkipCount());
            result.setWriteCount(result.getWriteCount() + stepExecution.getWriteCount());
            result.setWriteSkipCount(result.getWriteSkipCount() + stepExecution.getWriteSkipCount());
        }
    }
}

