/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BatchStepObservation implements ObservationDocumentation
{
    BATCH_STEP_OBSERVATION{

        public String getName() {
            return "spring.batch.step";
        }

        public String getContextualName() {
            return "%s";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return StepLowCardinalityTags.values();
        }

        public KeyName[] getHighCardinalityKeyNames() {
            return StepHighCardinalityTags.values();
        }

        public String getPrefix() {
            return "spring.batch";
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum StepHighCardinalityTags implements KeyName
    {
        STEP_EXECUTION_ID{

            public String asString() {
                return "spring.batch.step.executionId";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum StepLowCardinalityTags implements KeyName
    {
        STEP_NAME{

            public String asString() {
                return "spring.batch.step.name";
            }
        }
        ,
        STEP_TYPE{

            public String asString() {
                return "spring.batch.step.type";
            }
        }
        ,
        JOB_NAME{

            public String asString() {
                return "spring.batch.step.job.name";
            }
        }
        ,
        STEP_STATUS{

            public String asString() {
                return "spring.batch.step.status";
            }
        };

    }
}

