/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class GroupAwareJob
implements Job {
    private static final String SEPARATOR = ".";
    private final Job delegate;
    private final String groupName;

    public GroupAwareJob(Job delegate) {
        this(null, delegate);
    }

    public GroupAwareJob(@Nullable String groupName, Job delegate) {
        this.groupName = groupName;
        this.delegate = delegate;
    }

    @Override
    public void execute(JobExecution execution) {
        this.delegate.execute(execution);
    }

    @Override
    public String getName() {
        return this.groupName == null ? this.delegate.getName() : this.groupName + SEPARATOR + this.delegate.getName();
    }

    @Override
    public boolean isRestartable() {
        return this.delegate.isRestartable();
    }

    @Override
    @Nullable
    public JobParametersIncrementer getJobParametersIncrementer() {
        return this.delegate.getJobParametersIncrementer();
    }

    @Override
    public JobParametersValidator getJobParametersValidator() {
        return this.delegate.getJobParametersValidator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupAwareJob) {
            return ((GroupAwareJob)obj).delegate.equals(this.delegate);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return ClassUtils.getShortName(this.delegate.getClass()) + ": [name=" + this.getName() + "]";
    }
}

