/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.item.assignment;

import de.werum.sis.mapping.item.Assignment;
import de.werum.sis.mapping.item.assignment.AssignmentKey;
import de.werum.sis.mapping.item.assignment.AssignmentStore;
import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AssignmentMN
extends AssignmentStore
implements Assignment {
    public AssignmentMN() {
    }

    public AssignmentMN(AssignmentStore assignment) throws InvalidAssignmentDataException {
        super(assignment);
    }

    public Object put(String leftKey, String rightKey, Object value) {
        if (leftKey == null) {
            throw new IllegalArgumentException("left Key is null!");
        }
        if (rightKey == null) {
            throw new IllegalArgumentException("right Key is null!");
        }
        this.put(leftKey, (Object)rightKey, this.getLeftToRight());
        this.put(rightKey, (Object)leftKey, this.getRightToLeft());
        return this.getAssignmentValue().put(new AssignmentKey(leftKey.toString(), rightKey.toString()), value);
    }

    public Object remove(String leftKey, String rightKey) {
        if (leftKey == null) {
            throw new IllegalArgumentException("left Key is null!");
        }
        if (rightKey == null) {
            throw new IllegalArgumentException("right Key is null!");
        }
        this.remove(leftKey, rightKey, this.getLeftToRight());
        this.remove(rightKey, leftKey, this.getRightToLeft());
        return this.getAssignmentValue().remove(new AssignmentKey(leftKey.toString(), rightKey.toString()));
    }

    public Object get(String leftKey, String rightKey) {
        if (leftKey == null) {
            throw new IllegalArgumentException("left Key is null!");
        }
        if (rightKey == null) {
            throw new IllegalArgumentException("right Key is null!");
        }
        return this.getAssignmentValue().get(new AssignmentKey(leftKey.toString(), rightKey.toString()));
    }

    public boolean containsKey(String leftKey, String rightKey) {
        return this.getLeftToRight().containsKey(leftKey) && this.getRightToLeft().containsKey(rightKey) && this.getAssignmentValue().containsKey(new AssignmentKey(leftKey.toString(), rightKey.toString()));
    }

    public Collection values() {
        return this.getAssignmentValue().values();
    }

    public List getAssignmentsForLeft(String key) {
        if (this.getValue(key, this.getLeftToRight()) == null) {
            return null;
        }
        ArrayList value = new ArrayList();
        Iterator iterator = ((List)this.getValue(key, this.getLeftToRight())).iterator();
        while (iterator.hasNext()) {
            value.add(iterator.next());
        }
        return value;
    }

    public List getAssignmentsForRight(String key) {
        if (this.getValue(key, this.getRightToLeft()) == null) {
            return null;
        }
        ArrayList value = new ArrayList();
        Iterator iterator = ((List)this.getValue(key, this.getRightToLeft())).iterator();
        while (iterator.hasNext()) {
            value.add(iterator.next());
        }
        return value;
    }

    public Collection getAssignmentValues() {
        return this.assignmentValue_.values();
    }
}

