/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.display.helper;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.item.MappingContainer;
import de.werum.sis.mapping.item.assignment.AssignmentStore;
import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import de.werum.sis.mapping.item.mappingelement.MappingElementObject;
import de.werum.sis.mapping.item.tree.MappingTreeModel;
import de.werum.sis.mapping.item.tree.MappingTreePath;
import de.werum.sis.mapping.util.PointXY;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;

public abstract class MappingDisplayHelper {
    private MappingContainer mapping_ = null;
    protected List leftSorted_ = null;
    protected List rightSorted_ = null;
    protected List assignmentCoordinates_ = null;
    protected Comparator leftComparator_ = null;
    protected Comparator rightComparator_ = null;
    private MappingTreeModel leftMappingModel_ = null;
    private MappingTreeModel rightMappingModel_ = null;

    public MappingDisplayHelper() {
        this(new MappingContainer());
    }

    public MappingDisplayHelper(MappingContainer mapping) {
        this.mapping_ = mapping;
        this.init();
    }

    public MappingDisplayHelper(SortedMap left, SortedMap right) {
        this(new MappingContainer(left, right));
    }

    public MappingDisplayHelper(SortedMap left, SortedMap right, AssignmentStore assignment, boolean validateassignment) throws InvalidAssignmentDataException {
        this(new MappingContainer(left, right, assignment, validateassignment));
    }

    public void refresh() {
        if (this.getMapping().getLeftComparator() != null) {
            this.leftComparator_ = this.getMapping().getLeftComparator();
        }
        if (this.getMapping().getRightComparator() != null) {
            this.rightComparator_ = this.getMapping().getRightComparator();
        }
        this.leftSorted_ = new ArrayList(this.getMapping().getLeft().values());
        this.sortLeft();
        this.rightSorted_ = new ArrayList(this.getMapping().getRight().values());
        this.sortRight();
        this.refreshAssignmentCoordinates();
    }

    protected void init() {
        this.refresh();
    }

    public void sortLeft() {
        if (this.leftComparator_ != null) {
            Logger.getInstance().log(40, (Object)this, "sort target");
            Collections.sort(this.leftSorted_, this.leftComparator_);
        }
    }

    public void sortRight() {
        if (this.rightComparator_ != null) {
            Logger.getInstance().log(40, (Object)this, "sort source");
            Collections.sort(this.rightSorted_, this.rightComparator_);
        }
    }

    protected abstract void refreshAssignmentCoordinates();

    public void setLeftComparator(Comparator comp) {
        this.leftComparator_ = comp;
    }

    public void setRightComparator(Comparator comp) {
        this.rightComparator_ = comp;
    }

    public List getLeftSorted() {
        return this.leftSorted_;
    }

    public List getRightSorted() {
        return this.rightSorted_;
    }

    public MappingContainer getMapping() {
        if (this.mapping_ == null) {
            this.mapping_ = new MappingContainer();
            Logger.getInstance().warning(this, "mapping is null - initialized (new Mapping())");
        }
        return this.mapping_;
    }

    public void setMapping(MappingContainer mapping) {
        this.mapping_ = mapping;
        this.refresh();
    }

    public int getLeftIndex(Object key) {
        return this.getLeftSorted().indexOf(this.getMapping().getLeft().get(key));
    }

    public int getRightIndex(Object key) {
        return this.getRightSorted().indexOf(this.getMapping().getRight().get(key));
    }

    public void initLeftModel(MappingTreeModel model) {
        this.leftMappingModel_ = model;
    }

    protected MappingTreeModel getLeftModel() {
        return this.leftMappingModel_;
    }

    public void initRightModel(MappingTreeModel model) {
        this.rightMappingModel_ = model;
    }

    protected MappingTreeModel getRightModel() {
        return this.rightMappingModel_;
    }

    public MappingTreePath[] getLeftTreePath() {
        MappingTreePath[] treepaths = new MappingTreePath[this.getLeftSorted().size()];
        Iterator iterator = this.getLeftSorted().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            try {
                MappingElementObject cloneofelement = (MappingElementObject)((MappingElementObject)iterator.next()).clone();
                treepaths[index++] = new MappingTreePath(cloneofelement.getSplittedPath(), cloneofelement);
            }
            catch (CloneNotSupportedException goingdownthetoilet) {}
        }
        return treepaths;
    }

    public MappingTreePath[] getRightTreePath() {
        MappingTreePath[] treepaths = new MappingTreePath[this.getRightSorted().size()];
        Iterator iterator = this.getRightSorted().iterator();
        int index = 0;
        while (iterator.hasNext()) {
            try {
                MappingElementObject cloneofelement = (MappingElementObject)((MappingElementObject)iterator.next()).clone();
                treepaths[index++] = new MappingTreePath(cloneofelement.getSplittedPath(), cloneofelement);
            }
            catch (CloneNotSupportedException goingdownthetoilet) {}
        }
        return treepaths;
    }

    public void paintAssignments(Graphics g) {
        Iterator iter = this.assignmentCoordinates_.iterator();
        while (iter.hasNext()) {
            AssignmentCoordinates asc = (AssignmentCoordinates)iter.next();
            if (!asc.paintCoordinate()) continue;
            g.drawLine(asc.P1.X, asc.P1.Y, asc.P2.X, asc.P2.Y);
        }
    }

    protected class AssignmentCoordinates {
        public PointXY P1 = null;
        public PointXY P2 = null;
        public String assignmentKeyP1 = null;
        public String assignmentKeyP2 = null;
        private boolean paintCoordinate_ = true;

        public AssignmentCoordinates() {
        }

        public AssignmentCoordinates(PointXY p1, PointXY p2, String keyP1, String keyP2) {
            this.P1 = p1;
            this.P2 = p2;
            this.assignmentKeyP1 = keyP1;
            this.assignmentKeyP2 = keyP2;
        }

        public AssignmentCoordinates(PointXY p1, PointXY p2, String keyP1, String keyP2, boolean paintit) {
            this(p1, p2, keyP1, keyP2);
            this.paintCoordinate_ = paintit;
        }

        public void setPaintCoordinate(boolean paintit) {
            this.paintCoordinate_ = paintit;
        }

        public boolean paintCoordinate() {
            if (!this.paintCoordinate_) {
                return false;
            }
            if (this.P1 == null || this.P2 == null || this.assignmentKeyP1 == null || this.assignmentKeyP2 == null) {
                return false;
            }
            if (this.P1.Y <= 0 || this.P2.Y <= 0) {
                return false;
            }
            return !this.assignmentKeyP1.equals("") && !this.assignmentKeyP2.equals("");
        }
    }
}

