/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.Filter;
import de.werum.sis.csv.filter.FilterConstants;
import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSet;
import de.werum.sis.csv.filter.FilterFieldSetInstance;
import de.werum.sis.xmlgen.XMLGeneratorUtil;
import java.util.List;

public class FilterXmlGenerator
implements FilterConstants {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT = "   ";

    public StringBuffer generate(Filter filter) {
        StringBuffer out = new StringBuffer();
        out.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.append(LINE_SEPARATOR);
        out.append('<');
        out.append("filter");
        out.append(' ');
        out.append("type");
        out.append("=\"");
        if (filter.getType() == 2) {
            out.append("ascii");
        } else {
            out.append("csv");
        }
        out.append('\"');
        if (filter.getId() != null && filter.getId().length() > 0) {
            out.append(' ');
            out.append("id");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(filter.getId()));
            out.append('\"');
        }
        if (filter.getName() != null && filter.getName().length() > 0) {
            out.append(' ');
            out.append("name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(filter.getName()));
            out.append('\"');
        }
        if (filter.getJspName() != null && filter.getJspName().length() > 0) {
            out.append(' ');
            out.append("jsp");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(filter.getJspName()));
            out.append('\"');
        }
        out.append('>');
        out.append(LINE_SEPARATOR);
        this.writeFields(out, INDENT, filter.getFields());
        for (int i = 0; i < filter.getFieldSets().size(); ++i) {
            this.writeFieldSet(out, INDENT, filter.getFieldSets().get(i));
        }
        out.append("</");
        out.append("filter");
        out.append('>');
        out.append(LINE_SEPARATOR);
        return out;
    }

    private void writeField(StringBuffer out, String indent, FilterField field) {
        out.append(indent);
        out.append('<');
        out.append("field");
        if (field.getName() != null && field.getName().length() > 0) {
            out.append(' ');
            out.append("name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(field.getName()));
            out.append('\"');
        }
        if (field.getNameImport() != null && field.getNameImport().length() > 0) {
            out.append(' ');
            out.append("import-name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(field.getNameImport()));
            out.append('\"');
        }
        if (field.getPosition() != null) {
            out.append(' ');
            out.append("position");
            out.append("=\"");
            out.append(field.getPosition());
            out.append('\"');
        }
        if (field.getLength() != null) {
            out.append(' ');
            out.append("length");
            out.append("=\"");
            out.append(field.getLength());
            out.append('\"');
        }
        if (field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
            out.append('>');
            out.append(LINE_SEPARATOR);
            out.append(indent);
            out.append(INDENT);
            out.append('<');
            out.append("default");
            out.append('>');
            out.append(XMLGeneratorUtil.escapeStringXML(field.getDefaultValue()));
            out.append("</");
            out.append("default");
            out.append('>');
            out.append(LINE_SEPARATOR);
            out.append(indent);
            out.append("</");
            out.append("field");
        } else {
            out.append('/');
        }
        out.append('>');
        out.append(LINE_SEPARATOR);
    }

    private void writeFields(StringBuffer out, String indent, List<Object> fields) {
        for (Object object : fields) {
            if (object instanceof FilterField) {
                this.writeField(out, indent, (FilterField)object);
                continue;
            }
            if (!(object instanceof FilterFieldGroup)) continue;
            this.writeFieldGroup(out, indent, (FilterFieldGroup)object);
        }
    }

    private void writeFieldGroup(StringBuffer out, String indent, FilterFieldGroup fieldGroup) {
        out.append(indent);
        out.append('<');
        out.append("group");
        if (fieldGroup.getName() != null && fieldGroup.getName().length() > 0) {
            out.append(' ');
            out.append("name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(fieldGroup.getName()));
            out.append('\"');
        }
        if (fieldGroup.getNameImport() != null && fieldGroup.getNameImport().length() > 0) {
            out.append(' ');
            out.append("import-name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(fieldGroup.getNameImport()));
            out.append('\"');
        }
        out.append(' ');
        out.append("max");
        out.append("=\"");
        out.append(fieldGroup.getMaxNumber());
        out.append("\" ");
        out.append("number");
        out.append("=\"");
        out.append(fieldGroup.getNumber());
        out.append("\">");
        out.append(LINE_SEPARATOR);
        this.writeFields(out, indent + INDENT, fieldGroup.getFields());
        out.append(indent);
        out.append("</");
        out.append("group");
        out.append('>');
        out.append(LINE_SEPARATOR);
    }

    private void writeFieldSetInstance(StringBuffer out, String indent, FilterFieldSetInstance fieldSetInstance) {
        out.append(indent);
        out.append('<');
        out.append("instance");
        if (fieldSetInstance.getName() != null && fieldSetInstance.getName().length() > 0) {
            out.append(' ');
            out.append("name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(fieldSetInstance.getName()));
            out.append('\"');
        }
        out.append('>');
        out.append(LINE_SEPARATOR);
        this.writeFields(out, indent + INDENT, fieldSetInstance.getFields());
        out.append(indent);
        out.append("</");
        out.append("instance");
        out.append('>');
        out.append(LINE_SEPARATOR);
    }

    private void writeFieldSet(StringBuffer out, String indent, FilterFieldSet fieldSet) {
        out.append(indent);
        out.append('<');
        out.append("set");
        if (fieldSet.getName() != null && fieldSet.getName().length() > 0) {
            out.append(' ');
            out.append("name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(fieldSet.getName()));
            out.append('\"');
        }
        if (fieldSet.getNameImport() != null && fieldSet.getNameImport().length() > 0) {
            out.append(' ');
            out.append("import-name");
            out.append("=\"");
            out.append(XMLGeneratorUtil.escapeStringXML(fieldSet.getNameImport()));
            out.append('\"');
        }
        out.append(' ');
        out.append("additive");
        out.append("=\"");
        out.append(fieldSet.isAdditive());
        out.append("\">");
        out.append(LINE_SEPARATOR);
        this.writeFields(out, indent + INDENT, fieldSet.getFields());
        for (int i = 0; i < fieldSet.getInstances().size(); ++i) {
            this.writeFieldSetInstance(out, indent + INDENT, fieldSet.getInstances().get(i));
        }
        out.append(indent);
        out.append("</");
        out.append("set");
        out.append('>');
        out.append(LINE_SEPARATOR);
    }
}

