/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.crypt.HybridCipherExtractor;
import de.werum.sis.trace.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class DecryptWCR {
    static ConsoleLogger lgMain = ConsoleLogger.getInstance();
    private static File outDir = null;
    private static String outDirName = null;
    private static boolean doZip = false;
    private static int firstFilenameId = 0;
    private static final int BUFFER_SIZE = 1024;

    public static void main(String[] args) {
        try {
            int i = DecryptWCR.interpreteArgements(args);
            if (outDirName != null) {
                try {
                    outDir = new File(outDirName);
                    if (outDir != null && !outDir.isDirectory()) {
                        outDir = null;
                    }
                }
                catch (Exception ex) {
                    outDir = null;
                }
            }
            while (i < args.length) {
                File aktFile = new File(args[i]);
                if (aktFile != null) {
                    if (aktFile.isDirectory()) {
                        String[] Inhalt = aktFile.list();
                        for (int j = 0; j < Inhalt.length; ++j) {
                            File aktSubFile = new File(aktFile.getAbsolutePath() + "/" + Inhalt[j]);
                            DecryptWCR.decryptFile(aktSubFile);
                        }
                    } else if (aktFile.isFile()) {
                        DecryptWCR.decryptFile(aktFile);
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            lgMain.print(1, "Exception: " + ex.getMessage());
        }
        lgMain.print(3, "Fertig ...");
    }

    private static int interpreteArgements(String[] args) {
        boolean doInterprete = true;
        if (args.length == 0) {
            System.out.println("usage: java de.werum.sis.crypt.DecryptWCR [-o outdir] files|dirs");
            return -1;
        }
        int i = 0;
        while (doInterprete) {
            if ("-z".equals(args[i])) {
                doZip = true;
                ++i;
                continue;
            }
            if ("-o".equals(args[i])) {
                if (++i < args.length) {
                    outDirName = args[i];
                }
                ++i;
                continue;
            }
            doInterprete = false;
        }
        return i;
    }

    private static void decryptFile(File file) {
        lgMain.print(3, "-> DecryptWCR.decryptFile");
        if (file != null && file.isFile() && file.getName().endsWith(".wcr")) {
            lgMain.print(3, "Datei: <" + file.getName() + ">");
            try {
                FileInputStream f_is = null;
                CryptProperties prop = new CryptProperties();
                HybridCipherExtractor cipherExtractor = new HybridCipherExtractor(prop);
                Cipher cipher = null;
                try {
                    f_is = new FileInputStream(file);
                    cipher = cipherExtractor.extractCipher(f_is, false);
                }
                catch (StreamCorruptedException ex) {
                    f_is = new FileInputStream(file);
                    byte[] trash = new byte[4];
                    f_is.read(trash, 0, 4);
                    cipher = cipherExtractor.extractCipher(f_is, false);
                }
                lgMain.print(3, "Cipher-Algorithmus: " + cipher.getAlgorithm());
                CipherInputStream cipherInputStream = new CipherInputStream(f_is, cipher);
                GZIPInputStream g_is = new GZIPInputStream(cipherInputStream);
                String targetPath = outDirName;
                if (targetPath == null) {
                    targetPath = file.getAbsoluteFile().getParentFile().getAbsolutePath();
                }
                File newFile = null;
                newFile = file.getName().endsWith(".xml.wcr") ? new File(targetPath + "/" + file.getName().substring(0, file.getName().length() - 4)) : (file.getName().endsWith(".wcr") ? new File(targetPath + "/" + file.getName().substring(0, file.getName().length() - 4) + ".xml") : (outDirName == null ? new File(targetPath + "/" + file.getName() + ".xml") : new File(targetPath + "/" + file.getName())));
                FileOutputStream f_os = new FileOutputStream(newFile);
                byte[] copy_buffer = new byte[1024];
                int read_size = 0;
                while (read_size > -1) {
                    read_size = g_is.read(copy_buffer, 0, 1024);
                    if (read_size <= -1) continue;
                    f_os.write(copy_buffer, 0, read_size);
                }
                g_is.close();
                cipherInputStream.close();
                f_is.close();
                f_os.close();
            }
            catch (GeneralSecurityException ex) {
                lgMain.print(0, "Keine wcr-Datei: <" + file.getAbsolutePath() + "> Fehler: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Exception ex) {
                lgMain.print(0, "Fehler bei der Verarbeitung der Datei: <" + file.getAbsolutePath() + "> Fehler: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        lgMain.print(3, "<- DecryptWCR.decryptFile");
    }
}

