/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CipherExtractor;
import de.werum.sis.crypt.CryptProperties;
import de.werum.sis.crypt.TripleDESCipherExtractor;
import de.werum.sis.trace.ConsoleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;

public class DecryptInputStream
extends InputStream {
    ConsoleLogger lg = ConsoleLogger.getInstance();
    CipherInputStream cipherInputStream = null;

    public DecryptInputStream(CryptProperties properties, InputStream inputStream) throws GeneralSecurityException, IOException {
        TripleDESCipherExtractor cipherExtractor = new TripleDESCipherExtractor(properties);
        Cipher cipher = cipherExtractor.extractCipher(inputStream, false);
        this.cipherInputStream = new CipherInputStream(inputStream, cipher);
    }

    public DecryptInputStream(InputStream inputStream, CipherExtractor cipherExtractor) throws GeneralSecurityException, IOException {
        Cipher cipher = cipherExtractor.extractCipher(inputStream, false);
        this.cipherInputStream = new CipherInputStream(inputStream, cipher);
    }

    public DecryptInputStream(InputStream inputStream, CipherExtractor cipherExtractor, Cipher cipher) throws GeneralSecurityException, IOException {
        cipherExtractor.extractCipher(inputStream, false);
        this.cipherInputStream = new CipherInputStream(inputStream, cipher);
    }

    public long skip(long p0) throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        return this.cipherInputStream.skip(p0);
    }

    public int read(byte[] p0, int p1, int p2) throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        return this.cipherInputStream.read(p0, p1, p2);
    }

    public int read(byte[] p0) throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        return this.cipherInputStream.read(p0);
    }

    public int read() throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        return this.cipherInputStream.read();
    }

    public int available() throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        return this.cipherInputStream.available();
    }

    public synchronized void mark(int readlimit) {
        if (this.cipherInputStream != null) {
            this.cipherInputStream.mark(readlimit);
        }
    }

    public synchronized void reset() throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        this.cipherInputStream.reset();
    }

    public boolean markSupported() {
        if (this.cipherInputStream == null) {
            return false;
        }
        return this.cipherInputStream.markSupported();
    }

    public void close() throws IOException {
        if (this.cipherInputStream == null) {
            throw new IOException("DecryptInputStream not initialised");
        }
        this.cipherInputStream.close();
    }
}

