/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.parser.ErhebungsbeschreibungParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.SDFResolver;
import de.werum.sis.meta.parser.MainParser;
import de.werum.sis.meta.parser.ParserContextInterface;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;

public class SDFParser {
    private boolean checkNamespace = false;
    private boolean sdfGlobalNamespace = true;

    public void setCheckNamespace(boolean checkNamespace) {
        this.checkNamespace = checkNamespace;
    }

    public void setSDFGlobalNamespace(boolean sdfGlobalNamespace) {
        this.sdfGlobalNamespace = sdfGlobalNamespace;
    }

    public MetaErhebungsbeschreibung parse(String fileName) throws Exception {
        return this.parse(new File(fileName));
    }

    public MetaErhebungsbeschreibung parse(File file) throws Exception {
        MetaErhebungsbeschreibung sdf;
        try (FileReader reader = null;){
            reader = new FileReader(file);
            sdf = this.parse(reader);
            reader.close();
        }
        return sdf;
    }

    public MetaErhebungsbeschreibung parse(Reader reader) throws Exception {
        MainParser parser = new MainParser();
        SDFResolver resolver = new SDFResolver();
        ErhebungsbeschreibungParser rootParser = new ErhebungsbeschreibungParser((SuperParser)parser, resolver);
        parser.setParserContext((ParserContextInterface)new SDFParserContext(this.checkNamespace, this.sdfGlobalNamespace));
        parser.setResolver((ResolverInterface)resolver);
        MetaErhebungsbeschreibung sdf = (MetaErhebungsbeschreibung)parser.perform(reader, (SubParser)rootParser);
        parser.checkForErrors();
        return sdf;
    }
}

