/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.ContextParser;
import de.statspez.sdf.generator.parser.DateTimeParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReferencePeriodParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private DateTimeParser dateTimeParser;
    private DateTimeParser startDateParser;
    private DateTimeParser endDateParser;
    private ContextParser.ContextDataReceiver contextDataReceiver;

    public ReferencePeriodParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.dateTimeParser = new DateTimeParser(this, resolver, "dateTime");
        this.parserChain.addParser((SubParser)this.dateTimeParser);
        this.startDateParser = new DateTimeParser(this, resolver, "startDate");
        this.parserChain.addParser((SubParser)this.startDateParser);
        this.endDateParser = new DateTimeParser(this, resolver, "endDate");
        this.parserChain.addParser((SubParser)this.endDateParser);
        this.contextDataReceiver = null;
    }

    public void setContextDataReceiver(ContextParser.ContextDataReceiver contextDataReceiver) {
        this.contextDataReceiver = contextDataReceiver;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("referencePeriod".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("referencePeriod".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.contextDataReceiver.setGueltigkeitTyp((short)1);
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            throw MetaParseException.unknownTagException((String)localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("referencePeriod".equalsIgnoreCase(localName)) {
            this.disable();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (aParser == this.dateTimeParser) {
            this.contextDataReceiver.setGueltigAb(SDFUtil.getDateTimeEncoded(this.dateTimeParser.getDateTime()));
        } else if (aParser == this.startDateParser) {
            this.contextDataReceiver.setGueltigAb(SDFUtil.getDateTimeEncoded(this.startDateParser.getDateTime()));
            if (3 != this.contextDataReceiver.getGueltigkeitTyp()) {
                this.contextDataReceiver.setGueltigkeitTyp((short)2);
            }
        } else if (aParser == this.endDateParser) {
            this.contextDataReceiver.setGueltigBis(SDFUtil.getDateTimeEncoded(this.endDateParser.getDateTime()));
            this.contextDataReceiver.setGueltigkeitTyp((short)3);
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

