/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.statspez.sdf.generator.parser.TypesParser;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.Reference;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConditionParser
extends SubParser {
    private Vector conditions = new Vector();
    private String currentName = null;
    private String currentNotationClass = null;
    private boolean currentFalseProcessingStrict = false;
    private String currentCode = null;
    private MetaProgram currentSpecification = null;

    public ConditionParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public Iterator getConditions() {
        return this.conditions.iterator();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) {
        if ("condition".equalsIgnoreCase(localName)) {
            this.currentName = atts.getValue("name");
            this.currentFalseProcessingStrict = TypesParser.parseFalseProcessingStrict(atts.getValue("false-processing"));
        } else if ("notation".equalsIgnoreCase(localName)) {
            this.currentNotationClass = atts.getValue("class");
            if (this.currentNotationClass != null) {
                this.currentNotationClass = SDFTags.dekodiereXMLName(this.currentNotationClass);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if (!"description".equalsIgnoreCase(localName) && !"annotation".equalsIgnoreCase(localName)) {
            if ("notation".equalsIgnoreCase(localName)) {
                this.currentCode = chars;
                if (this.currentNotationClass != null && this.currentNotationClass.equalsIgnoreCase("PL")) {
                    try {
                        this.currentSpecification = Helper.metaStructureFor((String)("RUECKGABE " + chars));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Fehler in der Spezifikation.", e);
                    }
                }
            } else if ("targetNode".equalsIgnoreCase(localName)) {
                MetaCustomSDFBedingung condition = new MetaCustomSDFBedingung();
                condition.setReference(chars);
                this.resolver().registerForResolve(new Reference((MetaElementInterface)condition, "REFERENCE_FIELD", chars));
                this.conditions.add(condition);
            } else {
                handled = false;
            }
        }
        return handled;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("condition".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("condition".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.currentName = null;
            this.currentFalseProcessingStrict = false;
            this.currentNotationClass = null;
            this.currentCode = null;
            this.currentSpecification = null;
            this.conditions.clear();
            this.enable();
        } else if ("description".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("notation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("targetNode".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("condition".equalsIgnoreCase(localName)) {
            int i = 0;
            while (i < this.conditions.size()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)this.conditions.get(i);
                if (this.currentName != null) {
                    condition.setName(this.currentName);
                }
                if (this.currentFalseProcessingStrict) {
                    condition.setBedingungsTyp((short)2);
                } else {
                    condition.setBedingungsTyp((short)1);
                }
                if (this.currentCode != null) {
                    condition.setBedingung(this.currentCode);
                }
                if (this.currentSpecification != null) {
                    condition.setSpecification(this.currentSpecification);
                }
                ++i;
            }
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

