/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.qmino.miredot.annotations.ReturnType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.saiku.database.Database;
import org.saiku.service.user.UserService;
import org.saiku.web.rest.objects.UserList;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/api/license")
public class License {
    private UserService userService;
    private Database databaseManager;
    private static final int SIZE = 2048;

    public Database getDatabaseManager() {
        return this.databaseManager;
    }

    public void setDatabaseManager(Database databaseManager) {
        this.databaseManager = databaseManager;
    }

    public void setUserService(UserService us) {
        this.userService = us;
    }

    @GET
    @Path(value="/validate")
    @Produces(value={"text/plain"})
    @ReturnType(value="java.lang.String")
    public Response validateLicense() {
        return Response.ok().entity((Object)"Valid License").build();
    }

    @GET
    @Path(value="/usercount")
    @Produces(value={"application/json"})
    @ReturnType(value="java.util.ArrayList<UserList>")
    public Response getUserCount() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            List<String> l = this.getAuthUsers();
            if (l != null) {
                ArrayList<UserList> ul = new ArrayList<UserList>();
                int i = 0;
                for (String l2 : l) {
                    ul.add(new UserList(l2, i));
                    ++i;
                }
                return Response.ok().entity((Object)ul.size()).build();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)0).build();
        }
        return Response.ok().entity((Object)0).build();
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/json"})
    @ReturnType(value="java.util.ArrayList<UserList>")
    public Response getUserlist() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            List<String> l = this.getAuthUsers();
            if (l != null) {
                ArrayList<UserList> ul = new ArrayList<UserList>();
                int i = 0;
                for (String l2 : l) {
                    ul.add(new UserList(l2, i));
                    ++i;
                }
                return Response.ok().entity(ul).build();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @POST
    @Path(value="/users")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @ReturnType(value="java.lang.String")
    public Response createUserList(List<UserList> l) {
        try {
            ArrayList<String> l3 = new ArrayList<String>();
            for (UserList l2 : l) {
                l3.add(l2.getName());
            }
            this.addUsers(l3);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return Response.ok().entity((Object)"List created").build();
    }

    @PUT
    @Path(value="/users")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @ReturnType(value="java.lang.String")
    public Response updateUserList(List<UserList> l) {
        try {
            ArrayList<String> l3 = new ArrayList<String>();
            for (UserList l2 : l) {
                l3.add(l2.getName());
            }
            this.updateUsers(l3);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return Response.ok().entity((Object)"List updated").build();
    }

    @DELETE
    @Path(value="/users")
    @Produces(value={"application/json"})
    @ReturnType(value="java.lang.String")
    public Response deleteUserlist() {
        try {
            List<String> l = this.getAuthUsers();
            ArrayList<UserList> ul = new ArrayList<UserList>();
            int i = 0;
            for (String l2 : l) {
                ul.add(new UserList(l2, i));
                ++i;
            }
            return Response.ok().entity(ul).build();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getAuthUsers() throws SQLException {
        return this.databaseManager.getUsers();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/quota")
    @ReturnType(value="java.util.List<UserQuota>")
    public Response getUserQuota() {
        if (!this.userService.isAdmin()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.ok().entity((Object)100000000).build();
    }

    public void addUsers(List<String> l) throws SQLException {
        this.databaseManager.addUsers(l);
    }

    public void updateUsers(List<String> l) throws SQLException {
        this.databaseManager.addUsers(l);
    }
}

