/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.security.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.saiku.service.util.security.authentication.PasswordProvider;

public class FileBackedPasswordProvider
implements PasswordProvider {
    private final String password;

    public FileBackedPasswordProvider(File passwordPropertyFile, String passwordKey) {
        this.password = this.loadPasswordFromFile(passwordPropertyFile, passwordKey);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    private String loadPasswordFromFile(File passwordPropertyFile, String passwordKey) {
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(passwordPropertyFile);
            properties.load(inputStream);
            String password = properties.getProperty(passwordKey);
            if (password == null) {
                throw new RuntimeException("Did not find password key '" + passwordKey + "' in file " + passwordPropertyFile.getAbsolutePath());
            }
            String string = password;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load password from file: " + passwordPropertyFile.getAbsolutePath(), e);
        }
        finally {
            this.closeInputStream(inputStream);
        }
    }

    private void closeInputStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close input stream", e);
        }
    }
}

