/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util.export;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.saiku.olap.util.SaikuProperties;

public class ResultSetHelper {
    private final NumberFormat numberFormat = NumberFormat.getInstance(SaikuProperties.locale);
    private final SimpleDateFormat dateFormat;
    private final SimpleDateFormat timestampFormat;

    public ResultSetHelper() {
        if (SaikuProperties.webExportCsvUseFormattedValue.booleanValue()) {
            this.numberFormat.setGroupingUsed(true);
        } else {
            this.numberFormat.setGroupingUsed(false);
        }
        this.dateFormat = new SimpleDateFormat(SaikuProperties.webExportCsvDateFormat);
        this.timestampFormat = new SimpleDateFormat(SaikuProperties.webExportCsvTimestampFormat);
    }

    private String formatNumber(Object number) {
        return this.numberFormat.format(number);
    }

    private String read(Clob c) throws SQLException, IOException {
        StringBuilder sb = new StringBuilder((int)c.length());
        Reader r = c.getCharacterStream();
        char[] cbuf = new char[2048];
        int n = 0;
        while ((n = r.read(cbuf, 0, cbuf.length)) != -1) {
            if (n <= 0) continue;
            sb.append(cbuf, 0, n);
        }
        return sb.toString();
    }

    public String getValue(ResultSet rs, int colType, int colIndex) throws SQLException, IOException {
        String value = "";
        switch (colType) {
            case -7: {
                Object bit = rs.getObject(colIndex);
                if (bit == null) break;
                value = String.valueOf(bit);
                break;
            }
            case 16: {
                boolean b = rs.getBoolean(colIndex);
                if (rs.wasNull()) break;
                value = Boolean.valueOf(b).toString();
                break;
            }
            case 2005: {
                Clob c = rs.getClob(colIndex);
                if (c == null) break;
                value = this.read(c);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bd = rs.getBigDecimal(colIndex);
                if (bd == null) break;
                value = this.formatNumber(bd);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int intValue = rs.getInt(colIndex);
                if (rs.wasNull()) break;
                value = this.formatNumber(intValue);
                break;
            }
            case 2000: {
                Object obj = rs.getObject(colIndex);
                if (obj == null) break;
                value = String.valueOf(obj);
                break;
            }
            case 91: {
                Date date = rs.getDate(colIndex);
                if (date == null) break;
                value = this.dateFormat.format(date);
                break;
            }
            case 92: {
                Time t = rs.getTime(colIndex);
                if (t == null) break;
                value = t.toString();
                break;
            }
            case 93: {
                Timestamp tstamp = rs.getTimestamp(colIndex);
                if (tstamp == null) break;
                value = this.timestampFormat.format(tstamp);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                value = rs.getString(colIndex);
                break;
            }
            default: {
                value = "";
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }
}

