/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.saiku.database.JdbcUserDAO;
import org.saiku.database.dto.SaikuUser;
import org.saiku.service.ISessionService;
import org.saiku.service.datasource.DatasourceService;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.user.IUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService
implements IUserManager,
Serializable {
    private JdbcUserDAO uDAO;
    private IDatasourceManager iDatasourceManager;
    private DatasourceService datasourceService;
    private ISessionService sessionService;
    private List<String> adminRoles;
    private static final Logger log = LoggerFactory.getLogger(UserService.class);

    public void setAdminRoles(List<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    public void setJdbcUserDAO(JdbcUserDAO jdbcUserDAO) {
        this.uDAO = jdbcUserDAO;
    }

    public void setiDatasourceManager(IDatasourceManager repo) {
        this.iDatasourceManager = repo;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public DatasourceService getDatasourceService() {
        return this.datasourceService;
    }

    public void setDatasourceService(DatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    @Override
    public SaikuUser addUser(SaikuUser u) {
        this.uDAO.insert(u);
        this.uDAO.insertRole(u);
        this.iDatasourceManager.createUser(u.getUsername());
        return u;
    }

    @Override
    public boolean deleteUser(SaikuUser u) {
        this.uDAO.deleteUser(u);
        this.iDatasourceManager.deleteFolder("homes/home:" + u.getUsername());
        return true;
    }

    @Override
    public SaikuUser setUser(SaikuUser u) {
        return null;
    }

    public List<SaikuUser> getUsers() {
        Collection users = this.uDAO.findAllUsers();
        ArrayList<SaikuUser> l = new ArrayList<SaikuUser>();
        for (Object user : users) {
            l.add((SaikuUser)user);
        }
        return l;
    }

    @Override
    public SaikuUser getUser(int id) {
        return this.uDAO.findByUserId(id);
    }

    @Override
    public String[] getRoles(SaikuUser user) {
        return this.uDAO.getRoles(user);
    }

    @Override
    public void addRole(SaikuUser u) {
        this.uDAO.insertRole(u);
    }

    @Override
    public void removeRole(SaikuUser u) {
        this.uDAO.deleteRole(u);
    }

    @Override
    public void removeUser(String username) {
        SaikuUser u = this.getUser(Integer.parseInt(username));
        this.uDAO.deleteUser(username);
        this.iDatasourceManager.deleteFolder("homes/" + u.getUsername());
    }

    @Override
    public SaikuUser updateUser(SaikuUser u, boolean updatepassword) {
        SaikuUser user = this.uDAO.updateUser(u, updatepassword);
        this.uDAO.updateRoles(u);
        return user;
    }

    private List<String> getCurrentUserRolesList() {
        if (this.sessionService != null && this.sessionService.getAllSessionObjects() != null && this.sessionService.getAllSessionObjects().get("roles") != null) {
            return (List)this.sessionService.getAllSessionObjects().get("roles");
        }
        return new ArrayList<String>();
    }

    public String[] getCurrentUserRoles() {
        List<String> roles = this.getCurrentUserRolesList();
        String[] rolesArray = new String[roles.size()];
        return roles.toArray(rolesArray);
    }

    @Override
    public boolean isAdmin() {
        List<String> roles = this.getCurrentUserRolesList();
        if (roles != null) {
            return !Collections.disjoint(roles, this.adminRoles);
        }
        return true;
    }

    public void checkFolders() {
        String username = (String)this.sessionService.getAllSessionObjects().get("username");
        boolean home = true;
        if (username != null) {
            home = this.datasourceService.hasHomeDirectory(username);
        }
        if (!home) {
            this.datasourceService.createUserHome(username);
        }
    }

    @Override
    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    @Override
    public String getActiveUsername() {
        try {
            return (String)this.sessionService.getSession().get("username");
        }
        catch (Exception e) {
            log.error("Could not fetch username");
            return null;
        }
    }

    @Override
    public String getSessionId() {
        try {
            return (String)this.sessionService.getSession().get("sessionid");
        }
        catch (Exception e) {
            log.error("Could not get sessionid: " + e.getMessage());
            return null;
        }
    }
}

