/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.totals.aggregators;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mondrian.util.Format;
import org.olap4j.Cell;
import org.olap4j.metadata.Measure;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.olap.totals.aggregators.AvgAggregator;
import org.saiku.service.olap.totals.aggregators.BlankAggregator;
import org.saiku.service.olap.totals.aggregators.MaxAggregator;
import org.saiku.service.olap.totals.aggregators.MinAggregator;
import org.saiku.service.olap.totals.aggregators.SumAggregator;

public abstract class TotalAggregator {
    private static final Map<String, TotalAggregatorFactory> all;
    private String formattedValue;
    final Format format;

    TotalAggregator(Format format) {
        this.format = format;
    }

    public void addData(Cell cell) {
        try {
            Object value = cell.getValue();
            if (value instanceof Number) {
                double doubleVal = cell.getDoubleValue();
                this.addData(doubleVal);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void addData(double var1);

    protected abstract Double getValue();

    public abstract TotalAggregator newInstance(Format var1, Measure var2);

    public String getFormattedValue() {
        if (this.formattedValue != null) {
            return this.formattedValue;
        }
        Double value = this.getValue();
        if (value != null) {
            return this.format.format((Object)value);
        }
        return "";
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public TotalAggregator newInstance() {
        return this.newInstance("");
    }

    private TotalAggregator newInstance(String formatString) {
        return this.newInstance(new Format(formatString, SaikuProperties.locale), null);
    }

    public static TotalAggregator newInstanceByFunctionName(String functionName) {
        if (functionName == null || functionName.trim().length() == 0) {
            return all.get("not").create();
        }
        return all.get(functionName).create();
    }

    static {
        HashMap<String, TotalAggregatorFactory> tmp = new HashMap<String, TotalAggregatorFactory>();
        tmp.put("not", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return null;
            }
        });
        tmp.put("nil", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return new BlankAggregator(null);
            }
        });
        tmp.put("sum", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return new SumAggregator(null);
            }
        });
        tmp.put("max", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return new MaxAggregator(null);
            }
        });
        tmp.put("min", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return new MinAggregator(null);
            }
        });
        tmp.put("avg", new TotalAggregatorFactory(){

            @Override
            public TotalAggregator create() {
                return new AvgAggregator(null);
            }
        });
        all = Collections.unmodifiableMap(tmp);
    }

    private static interface TotalAggregatorFactory {
        public TotalAggregator create();
    }
}

