/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.totals;

import org.olap4j.Cell;
import org.olap4j.metadata.Measure;
import org.saiku.olap.query2.ThinMeasure;
import org.saiku.olap.query2.util.Fat;
import org.saiku.service.olap.totals.AxisInfo;
import org.saiku.service.olap.totals.FormatList;
import org.saiku.service.olap.totals.aggregators.TotalAggregator;

public class TotalNode {
    private final String[] captions;
    private final TotalAggregator[][] totals;
    private final boolean showsTotals;
    private final int cellsAdded;
    private int span;
    private int width;
    private AxisInfo dataAxisInfo;

    public TotalNode(String[] captions, Measure[] measures, TotalAggregator aggregatorTemplate, FormatList formatList, int count, AxisInfo dataAxisInfo) {
        this.captions = captions;
        this.dataAxisInfo = dataAxisInfo;
        boolean bl = this.showsTotals = aggregatorTemplate != null;
        if (this.showsTotals) {
            this.cellsAdded = captions != null ? captions.length : 1;
            this.totals = new TotalAggregator[this.cellsAdded][count];
            String axisName = dataAxisInfo.axis.getAxisOrdinal().name();
            if (aggregatorTemplate != null) {
                for (int i = 0; i < this.totals.length; ++i) {
                    for (int j = 0; j < this.totals[0].length; ++j) {
                        ThinMeasure tm;
                        int k = j % measures.length;
                        if (axisName.equals("COLUMNS")) {
                            k = i % measures.length;
                        }
                        if (measures[k] instanceof Fat.MeasureAdapter && (tm = ((Fat.MeasureAdapter)measures[k]).getThinMeasure()) != null && tm.getAggregators() != null && !tm.getAggregators().isEmpty()) {
                            boolean foundAggregator = false;
                            for (String agg : tm.getAggregators()) {
                                if (agg.indexOf("_") < 0) {
                                    this.totals[i][j] = TotalAggregator.newInstanceByFunctionName(agg).newInstance(formatList.getValueFormat(j, i), measures[k]);
                                    foundAggregator = true;
                                    break;
                                }
                                String[] tokens = agg.split("_");
                                if (!tokens[1].equals(axisName)) continue;
                                agg = tokens[0];
                                this.totals[i][j] = TotalAggregator.newInstanceByFunctionName(agg).newInstance(formatList.getValueFormat(j, i), measures[k]);
                                foundAggregator = true;
                                break;
                            }
                            if (foundAggregator) continue;
                        }
                        this.totals[i][j] = aggregatorTemplate.newInstance(formatList.getValueFormat(j, i), measures[i]);
                    }
                }
            }
        } else {
            this.totals = new TotalAggregator[0][count];
            this.cellsAdded = 0;
        }
    }

    public void addData(int member, int index, Cell cell) {
        this.totals[member][index].addData(cell);
    }

    public void setFormattedValue(int member, int index, String value) {
        this.totals[member][index].setFormattedValue(value);
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    private void appendSpan(int append) {
        this.span += append;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    private void appendWidth(int append) {
        this.width += append;
    }

    public void appendChild(TotalNode child) {
        this.appendSpan(child.getRenderedCount());
        this.appendWidth(child.width);
    }

    public String[] getMemberCaptions() {
        return this.captions;
    }

    public TotalAggregator[][] getTotalGroups() {
        return this.totals;
    }

    private int getRenderedCount() {
        return this.span + this.cellsAdded;
    }
}

