/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.saiku.service.util.dto.Plugin;
import org.springframework.beans.factory.annotation.Autowired;

public class PlatformUtilsService {
    private String filePath;

    @Autowired
    public void setPath(String path) {
        this.filePath = path;
    }

    public String getPath() {
        return this.filePath;
    }

    public ArrayList<Plugin> getAvailablePlugins() {
        ArrayList<Plugin> l = new ArrayList<Plugin>();
        File f = new File(this.filePath);
        String[] directories = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                return new File(current, name).isDirectory();
            }
        });
        if (directories != null && directories.length > 0) {
            for (String d : directories) {
                File subdir = new File(this.filePath + "/" + d);
                File[] subfiles = subdir.listFiles();
                if (subfiles == null) continue;
                for (File s : subfiles) {
                    if (!s.getName().equals("plugin.js")) continue;
                    Plugin p = new Plugin(s.getParentFile().getName(), "", "js/saiku/plugins/" + s.getParentFile().getName() + "/plugin.js");
                    l.add(p);
                }
            }
        }
        return l;
    }
}

