/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.repository;

import com.his.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.repository.Acl2;
import org.saiku.repository.AclEntry;
import org.saiku.repository.AclMethod;
import org.saiku.repository.AclType;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.repository.RepositoryFileObject;
import org.saiku.repository.RepositoryFolderObject;
import org.saiku.repository.ScopedRepo;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackRabbitRepositoryManager
implements IRepositoryManager {
    private static final String SAIKU_AUTH_PRINCIPAL = "SAIKU_AUTH_PRINCIPAL";
    private static final Logger log = LoggerFactory.getLogger(JackRabbitRepositoryManager.class);
    private static JackRabbitRepositoryManager ref;
    private final String data;
    private final String config;
    private final String password;
    private final String oldpassword;
    private final String defaultRole;
    private Repository repository;
    private Session session;
    private Node root;
    private UserService userService;
    private ScopedRepo sessionRegistry;
    private boolean workspaces;

    private JackRabbitRepositoryManager(String config, String data, String password, String oldpassword, String defaultRole, ScopedRepo sessionRegistry, boolean workspaces) {
        this.config = config;
        this.data = data;
        this.password = password;
        this.oldpassword = oldpassword;
        this.defaultRole = defaultRole;
        this.sessionRegistry = sessionRegistry;
        this.workspaces = workspaces;
    }

    public static synchronized JackRabbitRepositoryManager getJackRabbitRepositoryManager(String config, String data, String password, String oldpassword, String defaultRole, ScopedRepo sessionRegistry, boolean workspaces) {
        if (ref == null) {
            ref = new JackRabbitRepositoryManager(config, data, password, oldpassword, defaultRole, sessionRegistry, workspaces);
        }
        return ref;
    }

    private String getCookieUsername() {
        String cookieUsername = null;
        HttpSession session = this.getSession();
        if (session != null && this.workspaces && session.getAttribute(SAIKU_AUTH_PRINCIPAL) != null) {
            cookieUsername = (String)session.getAttribute(SAIKU_AUTH_PRINCIPAL);
        }
        if (cookieUsername != null && cookieUsername.trim().length() == 0) {
            cookieUsername = null;
        }
        return cookieUsername;
    }

    private HttpSession getSession() {
        try {
            return this.sessionRegistry.getSession();
        }
        catch (Exception e) {
            log.debug("Error while fetching the HTTPSession", (Throwable)e);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void init() {
    }

    private void login() throws RepositoryException {
        try {
            this.session = this.repository.login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
        }
        catch (Exception e) {
            if (this.oldpassword == null) {
                this.session = this.repository.login((Credentials)new SimpleCredentials("admin", this.password.toCharArray()));
            }
            try {
                this.session = this.repository.login((Credentials)new SimpleCredentials("admin", this.password.toCharArray()));
            }
            catch (Exception e2) {
                this.session = this.repository.login((Credentials)new SimpleCredentials("admin", this.oldpassword.toCharArray()));
            }
        }
        if (this.password != null && !this.password.equals("")) {
            UserManager userManager = ((JackrabbitSession)this.session).getUserManager();
            Authorizable authorizable = userManager.getAuthorizable("admin");
            ((User)authorizable).changePassword(this.password);
        }
    }

    @Override
    public boolean start(UserService userService) throws RepositoryException {
        this.userService = userService;
        if (this.session == null) {
            log.info("starting repo");
            String xml = this.config;
            String dir = this.data;
            RepositoryConfig config = RepositoryConfig.create((String)xml, (String)dir);
            this.repository = RepositoryImpl.create((RepositoryConfig)config);
            log.info("repo started");
            log.info("logging in");
            if (this.session == null) {
                this.login();
            }
            log.info("logged in");
            JackrabbitSession js = (JackrabbitSession)this.session;
            if (js.getUserManager().getAuthorizable("anon") == null) {
                js.getUserManager().createUser("anon", "anon");
                js.save();
            }
            this.session = js;
            this.root = this.session.getRootNode();
            this.root.getSession().save();
            this.createFiles();
            this.createFolders();
            this.createNamespace();
            this.createSchemas();
            this.createDataSources();
            Node n = JcrUtils.getOrAddFolder((Node)this.root, (String)"homes");
            n.addMixin("nt:saikufolders");
            HashMap<String, List<AclMethod>> m = new HashMap<String, List<AclMethod>>();
            ArrayList<AclMethod> l = new ArrayList<AclMethod>();
            l.add(AclMethod.READ);
            m.put(this.defaultRole, l);
            AclEntry e = new AclEntry("admin", AclType.SECURED, m, null);
            Acl2 acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            n = JcrUtils.getOrAddFolder((Node)this.root, (String)"datasources");
            n.addMixin("nt:saikufolders");
            m = new HashMap();
            l = new ArrayList();
            l.add(AclMethod.WRITE);
            l.add(AclMethod.READ);
            l.add(AclMethod.GRANT);
            m.put("ROLE_ADMIN", l);
            e = new AclEntry("admin", AclType.PUBLIC, m, null);
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            n = JcrUtils.getOrAddFolder((Node)this.root, (String)"etc");
            n.addMixin("nt:saikufolders");
            n = JcrUtils.getOrAddFolder((Node)n, (String)"legacyreports");
            n.addMixin("nt:saikufolders");
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            n = JcrUtils.getOrAddFolder((Node)this.root, (String)"etc/theme");
            n.addMixin("nt:saikufolders");
            n = JcrUtils.getOrAddFolder((Node)n, (String)"legacyreports");
            n.addMixin("nt:saikufolders");
            acl2 = new Acl2(n);
            acl2.addEntry(n.getPath(), e);
            acl2.serialize(n);
            this.session.save();
            log.info("node added");
        }
        return true;
    }

    @Override
    public void createUser(String u) throws RepositoryException {
        Node parent;
        if (this.session == null) {
            this.login();
        }
        if ((parent = JcrUtils.getNodeIfExists((Node)this.root, (String)"homes")) != null) {
            Node node = parent.addNode("home:" + u, "nt:folder");
            node.addMixin("nt:saikufolders");
            AclEntry e = new AclEntry(u, AclType.PRIVATE, null, null);
            Acl2 acl2 = new Acl2(node);
            acl2.addEntry(node.getPath(), e);
            acl2.serialize(node);
            node.getSession().save();
        }
    }

    public NodeIterator getHomeFolders() throws RepositoryException {
        Node homes = this.root.getNode("homes");
        return homes.getNodes();
    }

    public Node getHomeFolder(String path) throws RepositoryException {
        return this.root.getNode("homes").getNode("home:" + path);
    }

    public Node getFolder(String user, String directory) throws RepositoryException {
        return this.getHomeFolder(user).getNode(directory);
    }

    private Node getFolderNode(String directory) throws RepositoryException {
        if (directory.startsWith("/")) {
            directory = directory.substring(1, directory.length());
        }
        return this.root.getNode(directory);
    }

    @Override
    public void shutdown() {
        if (this.session != null) {
            this.session.logout();
            ((JackrabbitRepository)this.repository).shutdown();
            this.repository = null;
            this.session = null;
        }
    }

    @Override
    public boolean createFolder(String username, String folder) throws RepositoryException {
        Node userfolder = this.getHomeFolder(username);
        String[] path = folder.split("/");
        Node nest = null;
        for (String p : path) {
            if (nest == null) {
                nest = userfolder.addNode(p);
                continue;
            }
            nest.addNode(p);
        }
        userfolder.getSession().save();
        return true;
    }

    @Override
    public boolean deleteFolder(String folder) throws RepositoryException {
        Node node;
        if (folder.startsWith("/")) {
            folder = folder.substring(1, folder.length());
        }
        if ((node = JcrUtils.getNodeIfExists((Node)this.root, (String)folder)) != null) {
            node.remove();
            node.getSession().save();
            return true;
        }
        return false;
    }

    @Override
    public void deleteRepository() throws RepositoryException {
        while (this.root.getNodes().hasNext()) {
            this.root.getNodes().nextNode().remove();
        }
    }

    @Override
    public boolean moveFolder(String user, String folder, String source, String target) throws RepositoryException {
        Node root = this.getHomeFolder(user).getNode(source + "/" + folder);
        if (target == null) {
            root.getSession().move(root.getPath(), this.getHomeFolder(user).getPath() + "/" + root.getName());
            root.getSession().save();
        } else {
            root.getSession().move(root.getPath(), this.getHomeFolder(user).getPath());
            root.getSession().save();
        }
        return true;
    }

    public Node saveFile(Object file, String path, String user, String type, List<String> roles) throws RepositoryException {
        if (file == null) {
            String parent = path.contains("/") ? path.substring(0, path.lastIndexOf("/")) : "/";
            Node node = this.getFolder(parent);
            Acl2 acl2 = new Acl2(node);
            acl2.setAdminRoles(this.userService.getAdminRoles());
            if (acl2.canWrite(node, user, roles)) {
                throw new SaikuServiceException("Can't write to file or folder");
            }
            int pos = path.lastIndexOf("/");
            String filename = "./" + path.substring(pos + 1, path.length());
            Node resNode = node.addNode(filename, "nt:folder");
            resNode.addMixin("nt:saikufolders");
            return resNode;
        }
        int pos = path.lastIndexOf("/");
        String filename = "./" + path.substring(pos + 1, path.length());
        Node n = this.getFolder(path.substring(0, pos));
        Acl2 acl2 = new Acl2(n);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (acl2.canWrite(n, user, roles)) {
            throw new SaikuServiceException("Can't write to file or folder");
        }
        Node check = JcrUtils.getNodeIfExists((Node)n, (String)filename);
        if (check != null) {
            check.remove();
        }
        Node resNode = n.addNode(filename, "nt:file");
        switch (type) {
            case "nt:saikufiles": {
                resNode.addMixin("nt:saikufiles");
                break;
            }
            case "nt:mondrianschema": {
                resNode.addMixin("nt:mondrianschema");
                break;
            }
            case "nt:olapdatasource": {
                resNode.addMixin("nt:olapdatasource");
            }
        }
        Node contentNode = resNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:data", (String)file);
        resNode.getSession().save();
        return resNode;
    }

    @Override
    public void removeFile(String path, String user, List<String> roles) throws RepositoryException {
        Node node = this.getFolder(path);
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (!acl2.canRead(node, user, roles)) {
            throw new RepositoryException();
        }
        node.remove();
        node.getSession().save();
    }

    @Override
    public void moveFile(String source, String target, String user, List<String> roles) throws RepositoryException {
        Node node = this.getFolder(source);
        Node t = this.getFolder(target);
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (!acl2.canRead(node, user, roles) || acl2.canWrite(t, user, roles)) {
            throw new RepositoryException();
        }
        node.getSession().move(source, target + "/" + node.getName());
        node.getSession().save();
    }

    public Node saveInternalFile(Object file, String path, String type) throws RepositoryException {
        if (file == null) {
            String parent = path.substring(0, path.lastIndexOf("/"));
            Node node = this.getFolder(parent);
            int pos = path.lastIndexOf("/");
            String filename = "./" + path.substring(pos + 1, path.length());
            Node resNode = node.addNode(filename, "nt:folder");
            resNode.addMixin("nt:saikufolders");
            resNode.getSession().save();
            return resNode;
        }
        int pos = path.lastIndexOf("/");
        String filename = "./" + path.substring(pos + 1, path.length());
        Node n = this.getFolder(path.substring(0, pos));
        if (type == null) {
            type = "";
        }
        if (n.hasNode(filename)) {
            n.getNode(filename).remove();
        }
        Node resNode = n.addNode(filename, "nt:file");
        if (type.equals("nt:saikufiles")) {
            resNode.addMixin("nt:saikufiles");
        } else if (type.equals("nt:mondrianschema")) {
            resNode.addMixin("nt:mondrianschema");
        } else if (type.equals("nt:olapdatasource")) {
            resNode.addMixin("nt:olapdatasource");
        } else if (type != null && !type.equals("")) {
            resNode.addMixin(type);
        }
        Node contentNode = resNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:data", (String)file);
        resNode.getSession().save();
        return resNode;
    }

    public Node saveBinaryInternalFile(InputStream file, String path, String type) throws RepositoryException {
        if (file == null) {
            String parent = path.substring(0, path.lastIndexOf("/"));
            Node node = this.getFolder(parent);
            int pos = path.lastIndexOf("/");
            String filename = "./" + path.substring(pos + 1, path.length());
            Node resNode = node.addNode(filename, "nt:folder");
            resNode.addMixin("nt:saikufolders");
            return resNode;
        }
        int pos = path.lastIndexOf("/");
        String filename = "./" + path.substring(pos + 1, path.length());
        Node n = this.getFolder(path.substring(0, pos));
        if (type == null) {
            type = "";
        }
        if (n.hasNode(filename)) {
            n.getNode(filename).remove();
        }
        Node resNode = n.addNode(filename, "nt:file");
        if (type.equals("nt:saikufiles")) {
            resNode.addMixin("nt:saikufiles");
        } else if (type.equals("nt:mondrianschema")) {
            resNode.addMixin("nt:mondrianschema");
        } else if (type.equals("nt:olapdatasource")) {
            resNode.addMixin("nt:olapdatasource");
        } else if (type != null && !type.equals("")) {
            resNode.addMixin(type);
        }
        Node contentNode = resNode.addNode("jcr:content", "nt:resource");
        Binary binary = this.session.getValueFactory().createBinary(file);
        contentNode.setProperty("jcr:data", binary);
        resNode.getSession().save();
        return resNode;
    }

    @Override
    public String getFile(String s, String username, List<String> roles) throws RepositoryException {
        Node node = this.getFolder(s);
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (!acl2.canRead(node, username, roles)) {
            throw new RepositoryException();
        }
        return this.getFolder(s).getNodes("jcr:content").nextNode().getProperty("jcr:data").getString();
    }

    @Override
    public String getInternalFile(String s) throws RepositoryException {
        return this.getFolder(s).getNodes("jcr:content").nextNode().getProperty("jcr:data").getString();
    }

    @Override
    public InputStream getBinaryInternalFile(String s) throws RepositoryException {
        return this.getFolder(s).getNodes("jcr:content").nextNode().getProperty("jcr:data").getBinary().getStream();
    }

    @Override
    public void removeInternalFile(String s) throws RepositoryException {
        Node n = this.getFolder(s);
        n.remove();
        n.getSession().save();
    }

    @Override
    public List<MondrianSchema> getAllSchema() throws RepositoryException {
        QueryManager qm = this.session.getWorkspace().getQueryManager();
        String sql = "SELECT * FROM [nt:mondrianschema]";
        Query query = qm.createQuery(sql, "JCR-SQL2");
        QueryResult res = query.execute();
        NodeIterator node = res.getNodes();
        ArrayList<MondrianSchema> l = new ArrayList<MondrianSchema>();
        while (node.hasNext()) {
            Node n = node.nextNode();
            String p = n.getPath();
            MondrianSchema m = new MondrianSchema();
            m.setName(n.getName());
            m.setPath(p);
            l.add(m);
        }
        return l;
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles) {
        return this.getRepoObjects(this.root, type, username, roles, false);
    }

    @Override
    public List<IRepositoryObject> getAllFiles(List<String> type, String username, List<String> roles, String path) throws RepositoryException {
        Node node = JcrUtils.getNodeIfExists((String)path, (Session)this.session);
        return this.getRepoObjects(node, type, username, roles, true);
    }

    @Override
    public void deleteFile(String datasourcePath) {
        try {
            Node n = this.getFolder(datasourcePath);
            n.remove();
            n.getSession().save();
        }
        catch (RepositoryException e) {
            log.error("Could not remove file " + datasourcePath, (Throwable)e);
        }
    }

    private AclEntry getAclObj(String path) {
        Node node = null;
        try {
            node = this.getFolderNode(path);
        }
        catch (RepositoryException e) {
            log.error("Could not get file", (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        AclEntry entry = acl2.getEntry(path);
        if (entry == null) {
            entry = new AclEntry();
        }
        return entry;
    }

    @Override
    public AclEntry getACL(String object, String username, List<String> roles) {
        Node node = null;
        try {
            node = this.getFolderNode(object);
        }
        catch (RepositoryException e) {
            log.error("Could not get file/folder", (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (acl2.canGrant(node, username, roles)) {
            return this.getAclObj(object);
        }
        return null;
    }

    @Override
    public void setACL(String object, String acl, String username, List<String> roles) throws RepositoryException {
        ObjectMapper mapper = new ObjectMapper();
        log.debug("Set ACL to " + object + " : " + acl);
        AclEntry ae = null;
        try {
            ae = (AclEntry)mapper.readValue(acl, AclEntry.class);
        }
        catch (IOException e) {
            log.error("Could not read ACL blob", (Throwable)e);
        }
        Node node = null;
        try {
            node = this.getFolderNode(object);
        }
        catch (RepositoryException e) {
            log.error("Could not get file/folder " + object, (Throwable)e);
        }
        Acl2 acl2 = new Acl2(node);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        if (acl2.canGrant(node, username, roles) && node != null) {
            acl2.addEntry(object, ae);
            node = acl2.serialize(node);
        }
        if (node != null) {
            node.getSession().save();
        }
    }

    @Override
    public List<MondrianSchema> getInternalFilesOfFileType(String type) throws RepositoryException {
        QueryManager qm = this.session.getWorkspace().getQueryManager();
        String sql = "SELECT * FROM [nt:mongoschema]";
        Query query = qm.createQuery(sql, "JCR-SQL2");
        QueryResult res = query.execute();
        NodeIterator node = res.getNodes();
        ArrayList<MondrianSchema> l = new ArrayList<MondrianSchema>();
        while (node.hasNext()) {
            Node n = node.nextNode();
            String p = n.getPath();
            MondrianSchema m = new MondrianSchema();
            m.setName(n.getName());
            m.setPath(p);
            m.setType(type);
            l.add(m);
        }
        return l;
    }

    @Override
    public List<DataSource> getAllDataSources() throws RepositoryException {
        QueryManager qm = this.session.getWorkspace().getQueryManager();
        String sql = "SELECT * FROM [nt:olapdatasource]";
        Query query = qm.createQuery(sql, "JCR-SQL2");
        QueryResult res = query.execute();
        NodeIterator node = res.getNodes();
        ArrayList<DataSource> ds = new ArrayList<DataSource>();
        while (node.hasNext()) {
            Node n = node.nextNode();
            JAXBContext jaxbContext = null;
            Unmarshaller jaxbMarshaller = null;
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
                continue;
            }
            try {
                jaxbMarshaller = jaxbContext != null ? jaxbContext.createUnmarshaller() : null;
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
                continue;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(n.getNodes("jcr:content").nextNode().getProperty("jcr:data").getString().getBytes());
            DataSource d = null;
            try {
                d = (DataSource)(jaxbMarshaller != null ? jaxbMarshaller.unmarshal((InputStream)stream) : null);
            }
            catch (JAXBException e) {
                log.error("Could not read XML", (Throwable)e);
                continue;
            }
            if (d != null) {
                d.setPath(n.getPath());
            }
            if (this.getCookieUsername() != null) {
                if (!this.getCookieUsername().equals(d.getUsername())) continue;
                ds.add(d);
                continue;
            }
            ds.add(d);
        }
        return ds;
    }

    @Override
    public void saveDataSource(DataSource ds, String path, String user) throws RepositoryException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSource.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)ds, (OutputStream)baos);
        }
        catch (JAXBException e) {
            log.error("Could not read XML", (Throwable)e);
        }
        int pos = path.lastIndexOf("/");
        String filename = "./" + path.substring(pos + 1, path.length());
        Node n = this.getFolder(path.substring(0, pos));
        if (!n.hasNode(filename)) {
            Node resNode = n.addNode(filename, "nt:file");
            resNode.addMixin("nt:olapdatasource");
            Node contentNode = resNode.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:data", baos.toString());
            resNode.getSession().save();
        }
    }

    @Override
    public byte[] exportRepository() throws RepositoryException, IOException {
        ByteArrayOutputStream os2 = new ByteArrayOutputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.session.exportDocumentView("/", (OutputStream)os, false, false);
        ZipOutputStream zs = new ZipOutputStream(os2);
        ZipEntry e = new ZipEntry("backup.xml");
        zs.putNextEntry(e);
        zs.write(((Object)os).toString().getBytes());
        zs.closeEntry();
        zs.close();
        return os2.toByteArray();
    }

    @Override
    public void restoreRepository(byte[] xml) throws RepositoryException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(xml);
        this.session.importXML("/", (InputStream)stream, 2);
    }

    @Override
    public RepositoryFile getFile(String fileUrl) {
        Node n = null;
        try {
            n = this.getFolder(fileUrl);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        try {
            return new RepositoryFile(n != null ? n.getName() : null, null, null, fileUrl);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Node getFolder(String path) throws RepositoryException {
        String homeSuffix;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!this.session.nodeExists(path) && path.contains(homeSuffix = "home:")) {
            String user = path.substring(path.indexOf(homeSuffix) + homeSuffix.length());
            if (user.endsWith("/")) {
                user = user.substring(0, user.length() - 1);
            }
            this.createUser(user);
        }
        return this.session.getNode(path);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    private void createNamespace() throws RepositoryException {
        NamespaceRegistry ns = this.session.getWorkspace().getNamespaceRegistry();
        if (!Arrays.asList(ns.getPrefixes()).contains("home")) {
            ns.registerNamespace("home", "http://www.meteorite.bi/namespaces/home");
        }
    }

    private void createDataSources() throws RepositoryException {
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = manager.createNodeTypeTemplate();
        ntt.setName("nt:olapdatasource");
        String[] str = new String[]{"nt:file"};
        ntt.setDeclaredSuperTypeNames(str);
        ntt.setMixin(true);
        PropertyDefinitionTemplate pdt3 = manager.createPropertyDefinitionTemplate();
        pdt3.setName("jcr:data");
        pdt3.setRequiredType(1);
        PropertyDefinitionTemplate pdt4 = manager.createPropertyDefinitionTemplate();
        pdt4.setName("enabled");
        pdt4.setRequiredType(1);
        PropertyDefinitionTemplate pdt5 = manager.createPropertyDefinitionTemplate();
        pdt5.setName("owner");
        pdt5.setRequiredType(1);
        ntt.getPropertyDefinitionTemplates().add(pdt3);
        ntt.getPropertyDefinitionTemplates().add(pdt4);
        ntt.getPropertyDefinitionTemplates().add(pdt5);
        try {
            manager.registerNodeType((NodeTypeDefinition)ntt, false);
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    private void createSchemas() throws RepositoryException {
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = manager.createNodeTypeTemplate();
        ntt.setName("nt:mondrianschema");
        String[] str = new String[]{"nt:file"};
        ntt.setDeclaredSuperTypeNames(str);
        ntt.setMixin(true);
        PropertyDefinitionTemplate pdt = manager.createPropertyDefinitionTemplate();
        pdt.setName("schemaname");
        pdt.setRequiredType(1);
        pdt.isMultiple();
        PropertyDefinitionTemplate pdt2 = manager.createPropertyDefinitionTemplate();
        pdt2.setName("cubenames");
        pdt2.setRequiredType(1);
        pdt2.isMultiple();
        PropertyDefinitionTemplate pdt3 = manager.createPropertyDefinitionTemplate();
        pdt3.setName("jcr:data");
        pdt3.setRequiredType(1);
        PropertyDefinitionTemplate pdt4 = manager.createPropertyDefinitionTemplate();
        pdt4.setName("owner");
        pdt4.setRequiredType(1);
        ntt.getPropertyDefinitionTemplates().add(pdt);
        ntt.getPropertyDefinitionTemplates().add(pdt2);
        ntt.getPropertyDefinitionTemplates().add(pdt3);
        ntt.getPropertyDefinitionTemplates().add(pdt4);
        try {
            manager.registerNodeType((NodeTypeDefinition)ntt, false);
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    private void createFiles() throws RepositoryException {
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = manager.createNodeTypeTemplate();
        ntt.setName("nt:saikufiles");
        String[] str = new String[]{"nt:file"};
        ntt.setDeclaredSuperTypeNames(str);
        ntt.setMixin(true);
        PropertyDefinitionTemplate pdt = manager.createPropertyDefinitionTemplate();
        pdt.setName("owner");
        pdt.setRequiredType(1);
        PropertyDefinitionTemplate pdt2 = manager.createPropertyDefinitionTemplate();
        pdt2.setName("type");
        pdt2.setRequiredType(1);
        PropertyDefinitionTemplate pdt4 = manager.createPropertyDefinitionTemplate();
        pdt4.setName("roles");
        pdt4.setRequiredType(1);
        PropertyDefinitionTemplate pdt5 = manager.createPropertyDefinitionTemplate();
        pdt5.setName("users");
        pdt5.setRequiredType(1);
        PropertyDefinitionTemplate pdt3 = manager.createPropertyDefinitionTemplate();
        pdt3.setName("jcr:data");
        pdt3.setRequiredType(1);
        ntt.getPropertyDefinitionTemplates().add(pdt);
        ntt.getPropertyDefinitionTemplates().add(pdt2);
        ntt.getPropertyDefinitionTemplates().add(pdt3);
        ntt.getPropertyDefinitionTemplates().add(pdt4);
        ntt.getPropertyDefinitionTemplates().add(pdt5);
        try {
            manager.registerNodeType((NodeTypeDefinition)ntt, false);
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    @Override
    public void createFileMixin(String type) throws RepositoryException {
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = manager.createNodeTypeTemplate();
        ntt.setName(type);
        String[] str = new String[]{"nt:file"};
        ntt.setDeclaredSuperTypeNames(str);
        ntt.setMixin(true);
        PropertyDefinitionTemplate pdt = manager.createPropertyDefinitionTemplate();
        pdt.setName("owner");
        pdt.setRequiredType(1);
        PropertyDefinitionTemplate pdt2 = manager.createPropertyDefinitionTemplate();
        pdt2.setName("type");
        pdt2.setRequiredType(1);
        PropertyDefinitionTemplate pdt4 = manager.createPropertyDefinitionTemplate();
        pdt4.setName("roles");
        pdt4.setRequiredType(1);
        PropertyDefinitionTemplate pdt5 = manager.createPropertyDefinitionTemplate();
        pdt5.setName("users");
        pdt5.setRequiredType(1);
        PropertyDefinitionTemplate pdt3 = manager.createPropertyDefinitionTemplate();
        pdt3.setName("jcr:data");
        pdt3.setRequiredType(1);
        ntt.getPropertyDefinitionTemplates().add(pdt);
        ntt.getPropertyDefinitionTemplates().add(pdt2);
        ntt.getPropertyDefinitionTemplates().add(pdt3);
        ntt.getPropertyDefinitionTemplates().add(pdt4);
        ntt.getPropertyDefinitionTemplates().add(pdt5);
        try {
            manager.registerNodeType((NodeTypeDefinition)ntt, false);
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    @Override
    public Object getRepositoryObject() {
        return this.repository;
    }

    private void createFolders() throws RepositoryException {
        NodeTypeManager manager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate ntt = manager.createNodeTypeTemplate();
        ntt.setName("nt:saikufolders");
        String[] str = new String[]{"nt:folder"};
        ntt.setDeclaredSuperTypeNames(str);
        ntt.setMixin(true);
        PropertyDefinitionTemplate pdt = manager.createPropertyDefinitionTemplate();
        pdt.setName("owner");
        pdt.setRequiredType(1);
        PropertyDefinitionTemplate pdt2 = manager.createPropertyDefinitionTemplate();
        pdt2.setName("type");
        pdt2.setRequiredType(1);
        PropertyDefinitionTemplate pdt4 = manager.createPropertyDefinitionTemplate();
        pdt4.setName("roles");
        pdt4.setRequiredType(1);
        PropertyDefinitionTemplate pdt5 = manager.createPropertyDefinitionTemplate();
        pdt5.setName("users");
        pdt5.setRequiredType(1);
        ntt.getPropertyDefinitionTemplates().add(pdt);
        ntt.getPropertyDefinitionTemplates().add(pdt2);
        ntt.getPropertyDefinitionTemplates().add(pdt4);
        ntt.getPropertyDefinitionTemplates().add(pdt5);
        try {
            manager.registerNodeType((NodeTypeDefinition)ntt, false);
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    private List<IRepositoryObject> getRepoObjects(Node files, List<String> fileType, String username, List<String> roles, boolean includeparent) {
        Acl2 acl2 = new Acl2(files);
        acl2.setAdminRoles(this.userService.getAdminRoles());
        ArrayList<IRepositoryObject> repoObjects = new ArrayList<IRepositoryObject>();
        Iterable objects = null;
        NodeIterator n = null;
        try {
            if (includeparent) {
                String filename = files.getName();
                if (files.getPrimaryNodeType().getName().equals("nt:file")) {
                    if (fileType == null || filename.contains(FilenameUtils.getExtension((String)filename))) {
                        String extension = FilenameUtils.getExtension((String)files.getName());
                        List<AclMethod> acls = acl2.getMethods(files, username, roles);
                        repoObjects.add(new RepositoryFileObject(filename, "#" + files.getPath(), extension, files.getPath(), acls));
                    }
                    if (files.getPrimaryNodeType().getName().equals("nt:folder")) {
                        List<AclMethod> acls = acl2.getMethods(files, username, roles);
                        repoObjects.add(new RepositoryFolderObject(files.getName(), "#" + files.getPath(), files.getPath(), acls, this.getRepoObjects(files, fileType, username, roles, false)));
                    }
                }
            } else {
                n = files.getNodes();
                while (n.hasNext()) {
                    Node node = n.nextNode();
                    String nodetype = node.getPrimaryNodeType().getName();
                    String nodename = node.getName();
                    String nodepath = node.getPath();
                    objects = JcrUtils.getChildNodes((Node)node);
                    String s = node.getPrimaryNodeType().getName();
                    if (nodename.startsWith("jcr:") || nodename.startsWith("rep:")) continue;
                    if (acl2.canRead(node, username, roles)) {
                        List<AclMethod> acls = acl2.getMethods(node, username, roles);
                        if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                            if (fileType != null && !fileType.contains(FilenameUtils.getExtension((String)node.getName()))) continue;
                            String extension = FilenameUtils.getExtension((String)nodename);
                            repoObjects.add(new RepositoryFileObject(node.getName(), "#" + node.getPath(), extension, node.getPath(), acls));
                        }
                        if (node.getPrimaryNodeType().getName().equals("nt:folder")) {
                            repoObjects.add(new RepositoryFolderObject(node.getName(), "#" + node.getPath(), node.getPath(), acls, this.getRepoObjects(node, fileType, username, roles, false)));
                        }
                        Collections.sort(repoObjects, new Comparator<IRepositoryObject>(){

                            @Override
                            public int compare(IRepositoryObject o1, IRepositoryObject o2) {
                                if (o1.getType().equals((Object)IRepositoryObject.Type.FOLDER) && o2.getType().equals((Object)IRepositoryObject.Type.FILE)) {
                                    return -1;
                                }
                                if (o1.getType().equals((Object)IRepositoryObject.Type.FILE) && o2.getType().equals((Object)IRepositoryObject.Type.FOLDER)) {
                                    return 1;
                                }
                                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                            }
                        });
                    }
                    for (Node file : objects) {
                        if (file.getName().startsWith("jcr:") || file.getName().startsWith("rep:") || !acl2.canRead(file, username, roles)) continue;
                        String filename = file.getName();
                        String relativePath = file.getPath();
                        List<AclMethod> acls = acl2.getMethods(file, username, roles);
                        String s2 = file.getPrimaryNodeType().getName();
                        if (file.getPrimaryNodeType().getName().equals("nt:saikufiles")) {
                            if (fileType != null && !fileType.contains(FilenameUtils.getExtension((String)filename))) continue;
                            String extension = FilenameUtils.getExtension((String)nodename);
                            repoObjects.add(new RepositoryFileObject(filename, "#" + relativePath, extension, relativePath, acls));
                        }
                        if (file.getPrimaryNodeType().getName().equals("nt:folder")) {
                            // empty if block
                        }
                        Collections.sort(repoObjects, new Comparator<IRepositoryObject>(){

                            @Override
                            public int compare(IRepositoryObject o1, IRepositoryObject o2) {
                                if (o1.getType().equals((Object)IRepositoryObject.Type.FOLDER) && o2.getType().equals((Object)IRepositoryObject.Type.FILE)) {
                                    return -1;
                                }
                                if (o1.getType().equals((Object)IRepositoryObject.Type.FILE) && o2.getType().equals((Object)IRepositoryObject.Type.FOLDER)) {
                                    return 1;
                                }
                                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                            }
                        });
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error processing repo objects", (Throwable)e);
        }
        return repoObjects;
    }
}

