/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.util;

import org.olap4j.mdx.SelectNode;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.Selection;
import org.saiku.olap.util.exception.SaikuIncompatibleException;
import org.saiku.query.Query;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.SortOrder;
import org.saiku.query.mdx.GenericFilter;
import org.saiku.query.mdx.IFilterFunction;
import org.saiku.query.mdx.NFilter;

public class QueryConverter {
    public static SelectNode convert(org.olap4j.query.Query query) throws Exception {
        Query sQuery = QueryConverter.convertQuery(query);
        return sQuery.getSelect();
    }

    public static Query convertQuery(org.olap4j.query.Query query) throws Exception {
        Query sQuery = new Query(query.getName(), query.getCube());
        for (org.olap4j.query.QueryAxis axis : query.getAxes().values()) {
            if (axis.getLocation() == null) continue;
            QueryAxis sAxis = sQuery.getAxis(axis.getLocation());
            QueryConverter.convertAxis(axis, sAxis, sQuery);
        }
        return sQuery;
    }

    private static void convertAxis(org.olap4j.query.QueryAxis axis, QueryAxis sAxis, Query sQuery) throws Exception {
        for (QueryDimension qD : axis.getDimensions()) {
            QueryConverter.convertDimension(qD, sAxis, sQuery);
        }
        if (axis.getSortOrder() != null) {
            SortOrder so = SortOrder.valueOf((String)axis.getSortOrder().toString());
            sAxis.sort(so, axis.getSortIdentifierNodeName());
        }
        if (axis.getFilterCondition() != null) {
            sAxis.addFilter((IFilterFunction)new GenericFilter(axis.getFilterCondition()));
        }
        if (axis.getLimitFunction() != null) {
            NFilter nf = new NFilter(IFilterFunction.MdxFunctionType.valueOf((String)axis.getLimitFunction().toString()), axis.getLimitFunctionN().intValue(), axis.getLimitFunctionSortLiteral());
            sAxis.addFilter((IFilterFunction)nf);
        }
        sAxis.setNonEmpty(axis.isNonEmpty());
    }

    private static void convertDimension(QueryDimension qD, QueryAxis sAxis, Query sQuery) throws Exception {
        boolean first = true;
        String hierarchyName = null;
        QueryHierarchy qh = null;
        for (Selection sel : qD.getInclusions()) {
            if (first) {
                hierarchyName = sel.getRootElement() instanceof Member ? ((Member)sel.getRootElement()).getHierarchy().getUniqueName() : ((Level)sel.getRootElement()).getHierarchy().getUniqueName();
                qh = sQuery.getHierarchy(hierarchyName);
                first = false;
            }
            if (sel.getSelectionContext() != null) {
                throw new SaikuIncompatibleException("Cannot convert queries with selection context");
            }
            if (sel.getRootElement() instanceof Member) {
                if (sel.getOperator().equals((Object)Selection.Operator.MEMBER)) {
                    qh.includeMember(sel.getRootElement().getUniqueName());
                    continue;
                }
                throw new SaikuIncompatibleException("Cannot convert member selection using operator: " + sel.getOperator());
            }
            qh.includeLevel(sel.getRootElement().getName());
        }
        sAxis.addHierarchy(qh);
    }
}

