/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

class TqUtil {
    private static final String FORMULA_BEGIN = "${";
    private static final String FORMULA_END = "}";

    TqUtil() {
    }

    public static List<String> splitParameterValues(String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)value)) {
            String[] vs;
            for (String v : vs = value.split(",")) {
                v = v.trim();
                values.add(v);
            }
        }
        return values;
    }

    public static String replaceParameters(String input, Map<String, String> parameters) throws RuntimeException {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        if (!StringUtils.contains((String)input, (String)FORMULA_BEGIN)) {
            return input;
        }
        int startIdx = StringUtils.indexOf((String)input, (String)FORMULA_BEGIN);
        int contentStartIdx = startIdx + FORMULA_BEGIN.length();
        if (startIdx > -1) {
            int contentEndIdx = StringUtils.lastIndexOf((String)input, (String)FORMULA_END);
            int endIdx = contentEndIdx + FORMULA_END.length();
            if (contentEndIdx >= contentStartIdx) {
                String contents = StringUtils.substring((String)input, (int)contentStartIdx, (int)contentEndIdx);
                if (parameters.containsKey(contents)) {
                    StringBuilder result = new StringBuilder();
                    result.append(StringUtils.substring((String)input, (int)0, (int)startIdx));
                    String value = parameters.get(contents);
                    result.append(value);
                    result.append(StringUtils.substring((String)input, (int)endIdx, (int)input.length()));
                    return result.toString();
                }
                throw new RuntimeException("Cannot find value for paramter: " + contents + " in query parameter list!");
            }
        }
        return input;
    }
}

