/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2;

import com.his.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.olap4j.impl.Named;
import org.saiku.ArrayMapDeserializer;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.common.AbstractThinSortableQuerySet;

public class ThinHierarchy
extends AbstractThinSortableQuerySet
implements Named {
    private String name;
    private String caption;
    private String dimension;
    private Map<String, ThinLevel> levels = new HashMap<String, ThinLevel>();
    @JsonDeserialize(using=ArrayMapDeserializer.class)
    private Map<String, String> cmembers = new HashMap<String, String>();

    public ThinHierarchy() {
    }

    public ThinHierarchy(String uniqueName, String caption, String dimension, Map<String, ThinLevel> levels) {
        this.name = uniqueName;
        this.caption = caption;
        this.dimension = dimension;
        if (levels != null) {
            this.levels = levels;
        }
    }

    public ThinHierarchy(String uniqueName, String caption, String dimension, Map<String, ThinLevel> levels, List<String> tcm) {
        this.name = uniqueName;
        this.caption = caption;
        this.dimension = dimension;
        if (levels != null) {
            this.levels = levels;
        }
        for (String t : tcm) {
            this.cmembers.put(t, t);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Map<String, ThinLevel> getLevels() {
        return this.levels;
    }

    public ThinLevel getLevel(String name) {
        if (this.levels.containsKey(name)) {
            return this.levels.get(name);
        }
        return null;
    }

    public void setLevels(Map<String, ThinLevel> levels) {
        this.levels = levels;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public Map<String, String> getCmembers() {
        return this.cmembers;
    }

    public void setCmembers(Map<String, String> cmembers) {
        this.cmembers = cmembers;
    }
}

