/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.datasources.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import mondrian.rolap.RolapConnection;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.connection.encrypt.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaikuOlapConnection
implements ISaikuConnection {
    private String name;
    private boolean initialized = false;
    private Properties properties;
    private OlapConnection olapConnection;
    private String username;
    private String password;
    private String passwordenc;
    private static final Logger log = LoggerFactory.getLogger(SaikuOlapConnection.class);

    public SaikuOlapConnection(String name, Properties props) {
        this.name = name;
        this.properties = props;
    }

    public SaikuOlapConnection(Properties props) {
        this.properties = props;
        this.name = props.getProperty("name");
    }

    @Override
    public boolean connect() throws Exception {
        return this.connect(this.properties);
    }

    private String decryptPassword(String password) {
        if (password != null) {
            return CryptoUtil.decrypt(password);
        }
        return null;
    }

    @Override
    public boolean connect(Properties props) throws Exception {
        String safemode = null;
        try {
            safemode = System.getProperty("saiku.safemode");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (safemode != null && safemode.equals("true")) {
            log.debug("Not starting connection " + this.name + ", Saiku in safe mode");
            return false;
        }
        if (props.containsKey("csv") && props.getProperty("csv").equals("true") || props.containsKey("enabled") && props.getProperty("enabled").equals("true") || !props.containsKey("enabled")) {
            CharSequence[] jdbcTokens;
            CharSequence[] urlTokens;
            this.username = props.getProperty("username");
            this.password = props.getProperty("password");
            String driver = props.getProperty("driver");
            this.passwordenc = props.getProperty("encrypt.password");
            this.properties = props;
            String url = props.getProperty("location");
            if (this.passwordenc != null && this.passwordenc.equals("true")) {
                this.password = this.decryptPassword(this.password);
            }
            if (url.contains("Mondrian=4")) {
                url = url.replace("Mondrian=4; ", "");
                url = url.replace("jdbc:mondrian", "jdbc:mondrian4");
                url = url.replace("DataSource=", "DataSource=osgi:service/jdbc/");
            }
            if (url.length() > 0 && url.charAt(url.length() - 1) != ';') {
                url = url + ";";
            }
            if (driver.equals("mondrian.olap4j.MondrianOlap4jDriver")) {
                if (this.username != null && this.username.length() > 0) {
                    url = url + "JdbcUser=" + this.username + ";";
                }
                if (this.password != null && this.password.length() > 0) {
                    url = url + "JdbcPassword=" + this.password + ";";
                }
            }
            if (url.contains("mondrian://") && url.contains("model") && !(urlTokens = url.split(";"))[0].contains("mondrian://") && (jdbcTokens = urlTokens[0].split(":")).length == 5) {
                String[] modelTokens = jdbcTokens[4].split("/");
                String modelName = modelTokens[modelTokens.length - 1];
                if (!modelName.endsWith("-csv.json")) {
                    modelName = modelName.substring(0, modelName.length() - 4) + "-csv.json";
                }
                jdbcTokens[4] = "model=mondrian://datasources/" + modelName;
                urlTokens[0] = String.join((CharSequence)":", jdbcTokens);
                url = String.join((CharSequence)";", urlTokens);
            }
            Class.forName(driver);
            Connection connection = DriverManager.getConnection(url, this.username, this.password);
            if (connection != null) {
                OlapWrapper wrapper = (OlapWrapper)connection;
                OlapConnection tmpolapConnection = (OlapConnection)wrapper.unwrap(OlapConnection.class);
                if (tmpolapConnection == null) {
                    throw new Exception("Connection is null");
                }
                log.info("Catalogs:" + tmpolapConnection.getOlapCatalogs().size());
                this.olapConnection = tmpolapConnection;
                this.initialized = true;
                return true;
            }
        } else if (props.containsKey("enabled") && props.getProperty("enabled").equals("false")) {
            log.info("Datasource marked as disabled.");
            return false;
        }
        return false;
    }

    @Override
    public boolean clearCache() throws Exception {
        if (this.olapConnection.isWrapperFor(RolapConnection.class)) {
            log.info("Clearing cache");
            RolapConnection rcon = (RolapConnection)this.olapConnection.unwrap(RolapConnection.class);
            rcon.getCacheControl(null).flushSchemaCache();
        }
        return true;
    }

    @Override
    public String getDatasourceType() {
        return "OLAP";
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public Connection getConnection() {
        try {
            if (this.olapConnection.isClosed()) {
                this.connect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.olapConnection;
    }

    @Override
    public void setProperties(Properties props) {
        this.properties = props;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

