/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query.mdx;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.metadata.Hierarchy;
import org.saiku.query.mdx.AbstractFilterFunction;
import org.saiku.query.mdx.IFilterFunction;

public class NameLikeFilter
extends AbstractFilterFunction {
    private String op;
    private List<String> filterExpression = new ArrayList<String>();
    private IFilterFunction.MdxFunctionType type;
    private Hierarchy hierarchy;
    private String operator = " > ";

    public NameLikeFilter(Hierarchy hierarchy, String ... matchingExpression) {
        List<String> expressions = Arrays.asList(matchingExpression);
        this.filterExpression.addAll(expressions);
        this.hierarchy = hierarchy;
        this.type = IFilterFunction.MdxFunctionType.Filter;
    }

    public NameLikeFilter(Hierarchy hierarchy, List<String> matchingExpression) {
        this.hierarchy = hierarchy;
        this.filterExpression.addAll(matchingExpression);
        this.type = IFilterFunction.MdxFunctionType.Filter;
    }

    public NameLikeFilter(Hierarchy hierarchy, List<String> matchingExpression, String operator) {
        this.hierarchy = hierarchy;
        this.filterExpression.addAll(matchingExpression);
        this.type = IFilterFunction.MdxFunctionType.Filter;
        this.op = operator;
        if (operator != null && operator.equals("NOTEQUAL")) {
            this.operator = " = ";
        }
    }

    @Override
    public List<ParseTreeNode> getArguments(MdxParser parser) {
        ArrayList<CallNode> filters = new ArrayList<CallNode>();
        ArrayList<ParseTreeNode> arguments = new ArrayList<ParseTreeNode>();
        HierarchyNode h = new HierarchyNode(null, this.hierarchy);
        for (int i = 0; i < this.filterExpression.size(); ++i) {
            String filter = this.filterExpression.get(i);
            String o = this.operator;
            if (this.filterExpression.size() > 1 && i == 0) {
                o = " > ";
            }
            LiteralNode filterExp = LiteralNode.createString(null, (String)filter);
            CallNode currentMemberNode = new CallNode(null, "CurrentMember", Syntax.Property, new ParseTreeNode[]{h});
            CallNode currentMemberNameNode = new CallNode(null, "Name", Syntax.Property, new ParseTreeNode[]{currentMemberNode});
            CallNode instrNode = new CallNode(null, "Instr", Syntax.Function, new ParseTreeNode[]{currentMemberNameNode, filterExp});
            CallNode filterNode = new CallNode(null, o, Syntax.Infix, new ParseTreeNode[]{instrNode, LiteralNode.createNumeric(null, (BigDecimal)new BigDecimal(0), (boolean)true)});
            filters.add(filterNode);
        }
        if (filters.size() == 1) {
            arguments.addAll(filters);
        } else if (filters.size() > 1) {
            ParseTreeNode allfilter = (ParseTreeNode)filters.get(0);
            for (int i = 1; i < filters.size(); ++i) {
                allfilter = new CallNode(null, " OR ", Syntax.Infix, new ParseTreeNode[]{allfilter, (ParseTreeNode)filters.get(i)});
            }
            arguments.add(allfilter);
        }
        return arguments;
    }

    @Override
    public IFilterFunction.MdxFunctionType getFunctionType() {
        return this.type;
    }

    public List<String> getFilterExpression() {
        return this.filterExpression;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String getOp() {
        return this.op;
    }
}

