/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.xml;

import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.SSPTags;
import de.statspez.pleditor.generator.parser.Tags;
import de.statspez.pleditor.generator.xml.AbstractXmlGenerator;
import de.statspez.pleditor.generator.xml.FunktionXmlGenerator;
import de.statspez.pleditor.generator.xml.MetaToXmlConverter;
import de.statspez.pleditor.generator.xml.ParameterXmlGenerator;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class ThemenbereichXmlGenerator
extends AbstractXmlGenerator {
    public void printThemenbereich(PrintStream out, MetaThemenbereich themenbereich, String indentation) {
        out.println(indentation + "<" + Tags.printTag("topic"));
        this.printAttribut(out, "name", themenbereich.getName());
        this.printAttribut(out, "id", themenbereich.getId());
        this.printAttribut(out, "state", this.state(themenbereich.getFreigabeStatus()));
        out.println(">");
        String ab1 = this.indentation(indentation, 1);
        this.printProperties(out, themenbereich, ab1);
        this.printObjectContext(out, themenbereich, ab1);
        this.printFelder(out, themenbereich.getFelder(), ab1);
        this.printPruefungen(out, themenbereich.getPruefungen(), ab1);
        this.printAblaeufe(out, themenbereich.getAblaeufe(), ab1);
        this.printInitwerte(out, themenbereich.getInitialisierungswerte(), ab1);
        this.printVariablen(out, themenbereich.getVariablen(), ab1);
        this.printFunktionen(out, themenbereich.getFunktionen(), ab1);
        this.printMaterialReferencen(out, themenbereich.getMaterialreferenzen(), ab1);
        out.println(indentation + "</" + Tags.printTag("topic") + ">");
    }

    protected void printFelder(PrintStream out, Iterator felder, String indentation) {
        List list = this.sort(felder);
        for (int i = 0; i < list.size(); ++i) {
            MetaTBFeld obj = (MetaTBFeld)list.get(i);
            if (obj == null) continue;
            out.print(indentation + "<" + Tags.printTag("field"));
            this.printIdNameStateAttribute(out, obj);
            this.printAttribut(out, "type", MetaToXmlConverter.getFieldart(obj.getArt()));
            if (obj.getKlasse() != null) {
                this.printAttribut(out, "class", obj.getKlasse().getName());
                this.printAttribut(out, "class-id", obj.getKlasse().getId());
            } else {
                this.printAttribut(out, "class", "");
                this.printAttribut(out, "class-id", "");
            }
            if (obj.getDimensionLaenge() != null && obj.getDimensionLaenge().trim().length() > 0) {
                this.printAttribut(out, "dimensions", obj.getDimensionLaenge());
            }
            if (obj.getMerkmalFeldTyp() != -1) {
                this.printAttribut(out, "statistic-variable-type", MetaToXmlConverter.getMerkmalFeldTypFWXmlForKode(obj.getMerkmalFeldTyp()));
            }
            this.printAttribut(out, "multi-auswahl", obj.getMehrfachantworten() ? "1" : "0");
            this.printAttribut(out, "voluntary-question", obj.getFreiwilligeFrage() ? "1" : "0");
            out.println(">");
            String ab1 = this.indentation(indentation, 1);
            this.printProperties(out, obj, ab1);
            this.printObjectContext(out, obj, ab1);
            this.printPCDATA(out, "code", obj.getBelegung(), ab1);
            this.printPCDATA(out, Tags.printTag("displayName"), obj.getBezeichnung(), ab1);
            this.printPCDATA(out, Tags.printTag("shortName"), obj.getKurzbezeichnung(), ab1);
            this.printPCDATA(out, Tags.printTag("tooltip"), obj.getTooltip(), ab1);
            this.printPCDATA(out, Tags.printTag("explanations"), obj.getErlaeuterungen(), ab1);
            this.printPCDATA(out, Tags.printTag("instruction"), obj.getRegieanweisung(), ab1);
            this.printPCDATA(out, Tags.printTag("infolink"), obj.getInfolink(), ab1);
            this.printPCDATA(out, Tags.printTag("infotext"), obj.getInfotext(), ab1);
            this.printPCDATA(out, Tags.printTag("errorShort"), obj.getFehlertextKurz(), ab1);
            this.printPCDATA(out, Tags.printTag("errorLong"), obj.getFehlertextLang(), ab1);
            this.printPCDATA(out, Tags.printTag("correctionDescription"), obj.getKorrekturhinweis(), ab1);
            out.println(indentation + "</" + Tags.printTag("field") + ">");
        }
    }

    protected void printPruefungen(PrintStream out, Iterator pruefungen, String indentation) {
        String ab1 = this.indentation(indentation, 1);
        List list = this.sort(pruefungen);
        for (int i = 0; i < list.size(); ++i) {
            MetaCustomPruefung pruefung = (MetaCustomPruefung)list.get(i);
            if (pruefung == null) continue;
            out.print(indentation + "<" + Tags.printTag("check"));
            this.printIdNameStateAttribute(out, pruefung);
            this.printAttribut(out, "type", MetaToXmlConverter.getPruefungType(pruefung.getPruefungsart()));
            this.printAttribut(out, "nr", String.valueOf(pruefung.getLfdNr()));
            this.printAttribut(out, "method-id", String.valueOf(pruefung.getMethodenKategorieID()));
            this.printAttribut(out, "correction-id", String.valueOf(pruefung.getKorrekturart()));
            this.printAttribut(out, "error-weight", String.valueOf(pruefung.getFehlergewicht()));
            this.printAttribut(out, "ref-field", this.generateNamen(pruefung.getHauptBezugsfeld()));
            this.printAttribut(out, "ref-field-id", this.generateIds(pruefung.getHauptBezugsfeld()));
            this.printAttribut(out, "ref-field-index", pruefung.getHauptbezugsfeldIndex());
            out.println(">");
            this.printProperties(out, pruefung, ab1);
            this.printObjectContext(out, pruefung, ab1);
            this.printCDATA(out, Tags.printTag("code"), pruefung.getPLSpezifikation(), ab1);
            this.printPCDATA(out, Tags.printTag("errorShort"), pruefung.getFehlertextKurz(), ab1);
            this.printPCDATA(out, Tags.printTag("errorLong"), pruefung.getFehlertextLang(), ab1);
            this.printPCDATA(out, Tags.printTag("correctionDescription"), pruefung.getKorrekturhinweis(), ab1);
            out.println(indentation + "</" + Tags.printTag("check") + ">");
        }
    }

    protected void printAblaeufe(PrintStream out, Iterator ablaeufe, String indentation) {
        String ab1 = this.indentation(indentation, 1);
        List list = this.sort(ablaeufe);
        for (int i = 0; i < list.size(); ++i) {
            MetaPLAblauf ablauf = (MetaPLAblauf)list.get(i);
            if (ablauf == null) continue;
            out.print(indentation + "<" + Tags.printTag("flow"));
            this.printNameIdStateAttribute(out, ablauf);
            out.println(">");
            this.printProperties(out, ablauf, ab1);
            this.printObjectContext(out, ablauf, ab1);
            String code = "";
            if (ablauf.getSpezifikation() != null) {
                code = ablauf.getSpezifikation();
            }
            this.printCDATA(out, Tags.printTag("code"), code, ab1);
            out.println(indentation + "</" + Tags.printTag("flow") + ">");
        }
    }

    private void printInitwerte(PrintStream out, Iterator initwerte, String indentation) {
        if (initwerte != null) {
            ParameterXmlGenerator parameterXmlGenerator = new ParameterXmlGenerator();
            while (initwerte.hasNext()) {
                MetaPLInitwert initwert = (MetaPLInitwert)initwerte.next();
                parameterXmlGenerator.printParameter(out, this.indentation(indentation, 1), initwert.getName(), initwert.getTyp(), initwert.getLaenge(), initwert.getDimension(), initwert.getBeschreibung());
            }
        }
    }

    private void printVariablen(PrintStream out, Iterator variablen, String indentation) {
        if (variablen != null) {
            String ab1 = this.indentation(indentation, 1);
            while (variablen.hasNext()) {
                MetaPLVariable plVariable = (MetaPLVariable)variablen.next();
                if (plVariable == null) continue;
                out.println(indentation + "<" + Tags.printTag("variable"));
                this.printAttribut(out, "name", plVariable.getName());
                this.printAttribut(out, "type", MetaToXmlConverter.getFieldtype(plVariable.getTyp()));
                this.printAttribut(out, "length", String.valueOf(plVariable.getLaenge()));
                if (plVariable.getDimension() != null && plVariable.getDimension().trim().length() > 0) {
                    this.printAttribut(out, "dimensions", plVariable.getDimension());
                }
                this.printAttribut(out, "persistent", plVariable.getPersistent() ? "1" : "0");
                out.println(">");
                String beschreibung = plVariable.getBeschreibung();
                if (beschreibung != null && beschreibung.length() > 0) {
                    String ab2 = this.indentation(indentation, 2);
                    out.println(indentation + "<" + SSPTags.printTag("properties") + ">");
                    out.println(this.indentation(indentation, 1) + "<" + SSPTags.printTag("about") + ">");
                    this.printPCDATA(out, SSPTags.printTag("description"), beschreibung, ab2);
                    out.println(this.indentation(indentation, 1) + "</" + SSPTags.printTag("about") + ">");
                    out.println(indentation + "</" + SSPTags.printTag("properties") + ">");
                }
                this.printPCDATA(out, Tags.printTag("code"), plVariable.getBelegung(), ab1);
                out.println(indentation + "</" + Tags.printTag("variable") + ">");
            }
        }
    }

    private void printFunktionen(PrintStream out, Iterator funktionen, String indentation) {
        FunktionXmlGenerator funktionXmlGenerator = new FunktionXmlGenerator();
        List list = this.sort(funktionen);
        for (int i = 0; i < list.size(); ++i) {
            MetaCustomFunktion obj = (MetaCustomFunktion)list.get(i);
            if (obj == null) continue;
            funktionXmlGenerator.printFunktion(out, obj, indentation);
        }
    }

    private void printMaterialReferencen(PrintStream out, Iterator tbMaterialReferenzen, String indentation) {
        String ab1 = this.indentation(indentation, 1);
        List list = this.sort(tbMaterialReferenzen);
        for (int i = 0; i < list.size(); ++i) {
            MetaTBMaterialReferenz obj = (MetaTBMaterialReferenz)list.get(i);
            if (obj == null) continue;
            out.println(indentation + "<" + Tags.printTag("materialLink"));
            this.printAttribut(out, "link-name", obj.getName());
            this.printAttribut(out, "materialDefinition-name", obj.getMaterialbeschreibung().getName());
            this.printAttribut(out, "materialDefinition-id", obj.getMaterialbeschreibung().getId());
            out.println(">");
            if (obj.getKommentar() != null) {
                this.printPCDATA(out, SSPTags.printTag("annotation"), obj.getKommentar(), ab1);
            }
            out.println(indentation + "</" + Tags.printTag("materialLink") + ">");
        }
    }
}

