/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.parser.speclanguage.Scanner;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import junit.framework.TestCase;

public class ScannerTest
extends TestCase {
    private Scanner scanner = null;

    public ScannerTest(String arg0) {
        super(arg0);
    }

    public void test_01_bezeichner() throws Exception {
        String test = "foo bar foo123 foo123bar foo_bar _foo";
        String[] expected = new String[]{"foo", "bar", "foo123", "foo123bar", "foo_bar", "_foo"};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expected.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)91, (int)sym.sym);
            ScannerTest.assertEquals((Object)expected[i], (Object)sym.value);
        }
    }

    public void test_02_zahl() throws Exception {
        String test = "123 123.456";
        int[] expectedSym = new int[]{93, 92};
        String[] expectedVal = new String[]{"123", "123.456"};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expectedSym.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expectedSym[i], (int)sym.sym);
            ScannerTest.assertEquals((Object)expectedVal[i], (Object)sym.value);
        }
    }

    public void test_03_keywords() throws Exception {
        String test = "WIEDERHOLE FUER JEDES VON BIS SCHRITTWEITE SOLANGE WENN DANN SONST ENDE PRUEFE FEHLER ABBRUCH RUECKGABE GIB AUS MATERIAL VAR";
        int[] expected = new int[]{37, 16, 22, 34, 6, 28, 29, 36, 7, 30, 10, 25, 14, 2, 27, 18, 5, 23, 33};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expected.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
        }
    }

    public void test_04_operators() throws Exception {
        String test = "* / + - < > /= >= <= IN UND ODER NICHT";
        int[] expected = new int[]{68, 60, 72, 67, 66, 63, 70, 62, 65, 64, 73, 71, 69};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expected.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
        }
    }

    public void test_05_otherTerminals() throws Exception {
        String test = ", ; .. := ( [ ) ] -- -+ +- ++ { } & .";
        int[] expected = new int[]{76, 89, 90, 75, 84, 82, 88, 86, 78, 79, 80, 81, 83, 87, 74, 85};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expected.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)expected[i], (int)sym.sym);
        }
    }

    public void test_06_strings() throws Exception {
        String test = "'Dies ist eine Zeichenkette' 'eine andere Zeichenkette''Eine Zeichenkette mit \\'' 'noch mal \\'text in anfuehrungszeichen\\' '";
        String[] expected = new String[]{"Dies ist eine Zeichenkette", "eine andere Zeichenkette", "Eine Zeichenkette mit '", "noch mal 'text in anfuehrungszeichen' "};
        this.scanner.yyreset(new StringReader(test));
        Symbol sym = null;
        for (int i = 0; i < expected.length; ++i) {
            sym = this.scanner.next_token();
            ScannerTest.assertNotNull((Object)sym);
            ScannerTest.assertEquals((int)94, (int)sym.sym);
            ScannerTest.assertEquals((Object)expected[i], (Object)sym.value);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.scanner = new Scanner(new StringReader(""));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.scanner.yyclose();
    }
}

