/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import java.io.PrintWriter;
import java.io.StringWriter;

public class TestFailure {
    public static final int ABORTED = 1;
    public static final int UNEXPECTED_PLAUSI_ERROR = 2;
    public static final int MISSED_PLAUSI_ERROR = 3;
    public static final int UNEQUAL_PLAUSI_ERROR = 4;
    public static final int UNEXPECTED_OUTPUT_FIELD = 5;
    public static final int MISSED_OUTPUT_FIELD = 6;
    public static final int UNEQUAL_OUTPUT_FIELD_VALUE = 7;
    public static final int INFO_TYPE = 1;
    public static final int TEXT_SHORT = 2;
    public static final int TEXT_LONG = 3;
    public static final int CORRECTION_ADVICE = 4;
    public static final int RUNTIME_EXEPTION = 5;
    public static final int RUNTIME_EXEPTION_CLASS = 6;
    public static final int RUNTIME_EXEPTION_MESSAGE = 7;
    public static final int REFERENCE_FIELD = 8;
    public static final int USED_FIELD = 9;
    public static final int OUTPUT_FIELD = 10;
    private String testCase;
    private String context;
    private int reason;
    private Throwable exception;
    private String errorId;
    private int differingAttribute;
    private String expectedValue;
    private String receivedValue;

    public TestFailure(String testCase, String context, int reason) {
        this.testCase = testCase;
        this.context = context;
        this.reason = reason;
        this.exception = null;
        this.errorId = null;
        this.differingAttribute = -1;
        this.expectedValue = null;
        this.receivedValue = null;
    }

    public TestFailure(String testCase, String context, int reason, Throwable exception) {
        this(testCase, context, reason);
        this.exception = exception;
    }

    public TestFailure(String testCase, String context, int reason, String errorId) {
        this(testCase, context, reason);
        this.errorId = errorId;
    }

    public TestFailure(String testCase, String context, int reason, String errorId, int differingAttribute, String expectedValue, String receivedValue) {
        this(testCase, context, reason, errorId);
        this.differingAttribute = differingAttribute;
        this.expectedValue = expectedValue;
        this.receivedValue = receivedValue;
    }

    public String getTestCase() {
        return this.testCase;
    }

    public String getContext() {
        return this.context;
    }

    public int getReason() {
        return this.reason;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public int getDifferingAttribute() {
        return this.differingAttribute;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public String getReceivedValue() {
        return this.receivedValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.getTestCase());
        buffer.append(" (");
        buffer.append(this.getContext());
        buffer.append(")] ");
        switch (this.getReason()) {
            case 1: {
                buffer.append("Abbruch");
                break;
            }
            case 2: {
                buffer.append("Unerwarteter Plausi-Fehler: ");
                buffer.append(this.getErrorId());
                break;
            }
            case 3: {
                buffer.append("Plausi-Fehler nicht angeschrieben: ");
                buffer.append(this.getErrorId());
                break;
            }
            case 4: {
                buffer.append("Unterschiedlicher Plausi-Fehler: ");
                buffer.append(this.getErrorId());
                buffer.append(" - ");
                switch (this.getDifferingAttribute()) {
                    case 1: {
                        buffer.append("Info-Typ");
                        break;
                    }
                    case 2: {
                        buffer.append("Fehlertext");
                        break;
                    }
                    case 3: {
                        buffer.append("Beschreibung");
                        break;
                    }
                    case 4: {
                        buffer.append("Korrekturhinweis");
                        break;
                    }
                    case 5: {
                        buffer.append("Laufzeitfehler");
                        break;
                    }
                    case 6: {
                        buffer.append("Klasse des Laufzeitfehlers");
                        break;
                    }
                    case 7: {
                        buffer.append("Text des Laufzeitfehlers");
                        break;
                    }
                    case 8: {
                        buffer.append("Hauptbezugsfeld");
                        break;
                    }
                    case 9: {
                        buffer.append("Referenzierte Felder");
                        break;
                    }
                    default: {
                        buffer.append("Unbekannter Attribut");
                    }
                }
                buffer.append(" (erwartet: <");
                buffer.append(this.getExpectedValue());
                buffer.append(">, bekommen: <");
                buffer.append(this.getReceivedValue());
                buffer.append(">)");
                break;
            }
            case 7: {
                buffer.append("Unterschiedliche Feldwerte im Ergebnis: ");
                buffer.append(this.getErrorId());
                buffer.append(" - ");
                if (this.getDifferingAttribute() == 10) {
                    buffer.append("Feldwert");
                }
                buffer.append(" (erwartet: <");
                buffer.append(this.getExpectedValue());
                buffer.append(">, bekommen: <");
                buffer.append(this.getReceivedValue());
                buffer.append(">)");
                break;
            }
            case 5: {
                buffer.append("Unerwartetes Feld im Ergebnis: ");
                buffer.append(this.getErrorId());
                break;
            }
            case 6: {
                buffer.append("Feld nicht im Ergebnis: ");
                buffer.append(this.getErrorId());
                break;
            }
            default: {
                buffer.append("Unbekannter Fehler");
            }
        }
        if (this.getException() != null) {
            StringWriter writer = new StringWriter();
            this.getException().printStackTrace(new PrintWriter(writer));
            buffer.append("\nLaufzeitfehler: ");
            buffer.append(writer.getBuffer());
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

